/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DeploymentFilterable;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.RequireDescriptors;
import org.apache.openejb.config.UnknownModuleTypeException;
import org.apache.openejb.config.sys.Deployments;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.JavaSecurityManagers;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.URLs;
import org.apache.xbean.finder.UrlSet;
import org.apache.xbean.finder.filter.ExcludeIncludeFilter;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.Filters;
import org.apache.xbean.finder.filter.IncludeExcludeFilter;

public class DeploymentsResolver
implements DeploymentFilterable {
    private static final String EXCLUDE_INCLUDE_ORDER = SystemInstance.get().getOptions().get("openejb.exclude-include.order", "include-exclude");
    private static final String[] ignoreDirs = SystemInstance.get().getProperty("openejb.ignore.directories", ".svn,_svn,cvs,.git,.hg").split(",");
    private static final Logger logger = DeploymentLoader.LOGGER;
    private static File lib;

    public static boolean isExtractedDir(File f) {
        if (new File(f.getParentFile(), f.getName() + ".war").exists()) {
            return true;
        }
        return new File(f.getParentFile(), f.getName() + ".ear").exists();
    }

    protected static boolean isValidDirectory(File file) {
        if (file.isDirectory() && !file.isHidden() && !file.equals(lib)) {
            String fn = file.getName();
            for (String dir : ignoreDirs) {
                if (!fn.equalsIgnoreCase(dir)) continue;
                return false;
            }
            String[] files = file.list();
            return null != files && files.length > 0;
        }
        return false;
    }

    public static void loadFrom(Deployments dep, FileUtils path, List<File> jarList) {
        if (dep.getDir() != null) {
            try {
                DeploymentsResolver.loadFromDir(dep, path, jarList);
            }
            catch (Files.FileDoesNotExistException e) {
                logger.warning("File error: <Deployments dir=\"" + dep.getDir() + "\"> - " + e.getMessage());
            }
            catch (RuntimeException e) {
                String message = "Runtime error: <Deployments dir=\"" + dep.getDir() + "\"> - " + e.getMessage();
                logger.error(message);
                throw new DeploymentsConfigurationException(message);
            }
        } else if (dep.getFile() != null) {
            try {
                DeploymentsResolver.loadFromFile(dep, path, jarList);
            }
            catch (RuntimeException e) {
                String message = "<Deployments file=\"" + dep.getFile() + "\"> - " + e.getMessage();
                logger.error(message);
                throw new DeploymentsConfigurationException(message);
            }
        }
    }

    private static void loadFromFile(Deployments dep, FileUtils path, List<File> jarList) {
        File file = Files.path((File)path.getDirectory(), (String[])new String[]{dep.getFile()});
        Files.exists((File)file);
        Files.readable((File)file);
        Files.file((File)file);
        if (!jarList.contains(file)) {
            jarList.add(file);
        }
    }

    private static void loadFromDir(Deployments dep, FileUtils path, List<File> jarList) {
        File dir = Files.path((File)path.getDirectory(), (String[])new String[]{dep.getDir()});
        Files.exists((File)dir);
        Files.readable((File)dir);
        Files.dir((File)dir);
        Files.notHidden((File)dir);
        LinkedHashMap<String, Object> files = new LinkedHashMap<String, Object>();
        File[] list = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return DeploymentsResolver.isValidDirectory(f) && !DeploymentsResolver.isExtractedDir(f);
                }
                return true;
            }
        });
        if (list != null) {
            for (File file : list) {
                files.put(file.getAbsolutePath(), file);
            }
            for (File file : list) {
                if (!DeploymentsResolver.isArchive(file)) continue;
                String archive = file.getAbsolutePath();
                files.remove(archive.substring(0, archive.length() - 4));
            }
        }
        for (File file : files.values()) {
            if (jarList.contains(file)) continue;
            jarList.add(file);
        }
    }

    private static boolean isArchive(File file) {
        if (!file.isFile()) {
            return false;
        }
        if (!file.getName().toLowerCase().endsWith("ar")) {
            return false;
        }
        String name = file.getName();
        char c = name.charAt(name.length() - 4);
        return c == '.';
    }

    public static List<URL> loadFromClasspath(ClassLoader classLoader) {
        ClasspathSearcher searchResult = new ClasspathSearcher().loadUrls(classLoader);
        if (searchResult.prefiltered == null || searchResult.urlSet == null) {
            return new ArrayList<URL>();
        }
        try {
            int urlSize;
            ArrayList<URL> jarList = new ArrayList<URL>(searchResult.urls.size());
            int size = searchResult.urls.size();
            if (size == 0 && searchResult.include.length() > 0) {
                logger.warning("No classpath URLs matched.  Current settings: openejb.deployments.classpath.exclude='" + searchResult.exclude + "', " + "openejb.deployments.classpath.include" + "='" + searchResult.include + "'");
                return jarList;
            }
            if (size == 0 && !searchResult.filterDescriptors && searchResult.prefiltered.getUrls().size() == 0) {
                return jarList;
            }
            if (size < 20) {
                logger.debug("Inspecting classpath for applications: " + size + " urls.");
            } else {
                boolean willScrape;
                boolean bl = willScrape = searchResult.requireDescriptors.size() < RequireDescriptors.values().length;
                if (size < 50 && willScrape) {
                    logger.info("Inspecting classpath for applications: " + size + " urls. Consider adjusting your exclude/include.  Current settings: " + "openejb.deployments.classpath.exclude" + "='" + searchResult.exclude + "', " + "openejb.deployments.classpath.include" + "='" + searchResult.include + "'");
                } else if (willScrape) {
                    logger.warning("Inspecting classpath for applications: " + size + " urls.");
                    logger.warning("ADJUST THE EXCLUDE/INCLUDE!!!.  Current settings: openejb.deployments.classpath.exclude='" + searchResult.exclude + "', " + "openejb.deployments.classpath.include" + "='" + searchResult.include + "'");
                }
            }
            long begin = System.currentTimeMillis();
            DeploymentsResolver.processUrls("DeploymentsResolver1", searchResult.urls, classLoader, searchResult.requireDescriptors, jarList);
            long end = System.currentTimeMillis();
            long time = end - begin;
            UrlSet unchecked = new UrlSet(new URL[0]);
            if (!searchResult.filterDescriptors) {
                unchecked = NewLoaderLogic.applyBuiltinExcludes(searchResult.prefiltered.exclude(searchResult.prefiltered));
                if (searchResult.filterSystemApps) {
                    unchecked = unchecked.exclude(".*/openejb-[^/]+(.(jar|ear|war)(./)?|/target/classes/?)");
                }
                DeploymentsResolver.processUrls("DeploymentsResolver2", unchecked.getUrls(), classLoader, EnumSet.allOf(RequireDescriptors.class), jarList);
            }
            if (logger.isDebugEnabled()) {
                int urlCount = searchResult.urlSet.getUrls().size() + unchecked.getUrls().size();
                logger.debug("DeploymentsResolver: URLs after filtering: " + urlCount);
                for (URL url : searchResult.urlSet.getUrls()) {
                    logger.debug("Annotations path: " + url);
                }
                for (URL url : unchecked.getUrls()) {
                    logger.debug("Descriptors path: " + url);
                }
            }
            if ((urlSize = searchResult.urls.size()) == 0) {
                return jarList;
            }
            if (time < 1000L) {
                logger.debug("Searched " + urlSize + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urlSize + " milliseconds per url.");
            } else if (time < 4000L || urlSize < 3) {
                logger.info("Searched " + urlSize + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urlSize + " milliseconds per url.");
            } else if (time < 10000L) {
                logger.warning("Searched " + urlSize + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urlSize + " milliseconds per url.");
                logger.warning("Consider adjusting your openejb.deployments.classpath.exclude and openejb.deployments.classpath.include settings.  Current settings: exclude='" + searchResult.exclude + "', include='" + searchResult.include + "'");
            } else {
                logger.fatal("Searched " + urlSize + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urlSize + " milliseconds per url.  TOO LONG!");
                logger.fatal("ADJUST THE EXCLUDE/INCLUDE!!!.  Current settings: openejb.deployments.classpath.exclude='" + searchResult.exclude + "', " + "openejb.deployments.classpath.include" + "='" + searchResult.include + "'");
                ArrayList<String> list = new ArrayList<String>();
                for (URL uRL : searchResult.urls) {
                    list.add(uRL.toExternalForm());
                }
                Collections.sort(list);
                for (String string : list) {
                    logger.info("Matched: " + string);
                }
            }
            return jarList;
        }
        catch (IOException e1) {
            logger.warning("Unable to search classpath for modules: Received Exception: " + e1.getClass().getName() + " " + e1.getMessage(), e1);
            return new ArrayList<URL>();
        }
    }

    @Deprecated
    public static void loadFromClasspath(FileUtils ignored, List<URL> jarList, ClassLoader classLoader) {
        jarList.addAll(DeploymentsResolver.loadFromClasspath(classLoader));
    }

    @Deprecated
    public static void processUrls(String caller, List<URL> urls, ClassLoader classLoader, Set<RequireDescriptors> requireDescriptors, FileUtils ignored, List<URL> jarList) {
        DeploymentsResolver.processUrls(caller, urls, classLoader, requireDescriptors, jarList);
    }

    public static void processUrls(String caller, List<URL> urls, ClassLoader classLoader, Set<RequireDescriptors> requireDescriptors, List<URL> jarList) {
        for (URL url : urls) {
            boolean isValidURL;
            String urlProtocol = url.getProtocol();
            boolean bl = isValidURL = urlProtocol.equals("jar") || urlProtocol.equals("file");
            if (!isValidURL) {
                logger.warning("Unknown protocol " + urlProtocol);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug(caller + ".processing: " + url);
            }
            try {
                URL archive;
                DeploymentLoader deploymentLoader = new DeploymentLoader();
                Class<? extends DeploymentModule> moduleType = deploymentLoader.discoverModuleType(url, classLoader, requireDescriptors);
                if (!AppModule.class.isAssignableFrom(moduleType) && !EjbModule.class.isAssignableFrom(moduleType) && !PersistenceModule.class.isAssignableFrom(moduleType) && !ConnectorModule.class.isAssignableFrom(moduleType) && !ClientModule.class.isAssignableFrom(moduleType) || jarList.contains(archive = URLs.toFileUrl(url))) continue;
                jarList.add(archive);
                File file = URLs.toFile(archive);
                logger.info("Found " + moduleType.getSimpleName() + " in classpath: " + file.getAbsolutePath());
            }
            catch (IOException e) {
                logger.warning("Unable to determine the module type of " + url.toExternalForm() + ": Exception: " + e.getMessage(), e);
            }
            catch (UnknownModuleTypeException unknownModuleTypeException) {}
        }
    }

    static {
        try {
            lib = SystemInstance.get().getHome().getDirectory("lib", false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class ClasspathSearcher {
        private final String include;
        private final String exclude;
        private final boolean filterSystemApps;
        private final Set<RequireDescriptors> requireDescriptors;
        private final boolean filterDescriptors;
        private UrlSet urlSet;
        private UrlSet prefiltered;
        private List<URL> urls;

        public ClasspathSearcher() {
            Options options = SystemInstance.get().getOptions();
            this.include = options.get("openejb.deployments.classpath.include", ".*");
            this.exclude = options.get("openejb.deployments.classpath.exclude", "");
            this.filterSystemApps = options.get("openejb.deployments.classpath.filter.systemapps", true);
            this.requireDescriptors = options.getAll("openejb.deployments.classpath.require.descriptor", (Enum[])new RequireDescriptors[]{RequireDescriptors.CLIENT});
            this.filterDescriptors = options.get("openejb.deployments.classpath.filter.descriptors", false);
        }

        public List<URL> getUrls() {
            return this.urls;
        }

        private UrlSet cleanUpUrlSet(UrlSet set) {
            if (set.size() >= 5) {
                return set;
            }
            List copy = set.getUrls();
            for (URL url : set.getUrls()) {
                try {
                    if (!"file".equals(url.getProtocol()) || !copy.contains(new URL("jar:" + url.toExternalForm() + "!/"))) continue;
                    copy.remove(url);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            return new UrlSet((Collection)copy);
        }

        public ClasspathSearcher loadUrls(ClassLoader classLoader) {
            try {
                boolean isWindows;
                UrlSet original = this.cleanUpUrlSet(new UrlSet(classLoader));
                this.prefiltered = this.urlSet = URLs.cullSystemJars(original);
                Filter includeFilter = Filters.patterns((String[])new String[]{this.include});
                if (!".*".equals(this.include) || !"".equals(this.exclude)) {
                    Object filter = EXCLUDE_INCLUDE_ORDER.startsWith("include") ? new IncludeExcludeFilter(includeFilter, Filters.patterns((String[])new String[]{this.exclude})) : new ExcludeIncludeFilter(includeFilter, Filters.patterns((String[])new String[]{this.exclude}));
                    this.urlSet = this.urlSet.filter((Filter)filter);
                } else {
                    includeFilter = null;
                }
                if (this.prefiltered.size() == this.urlSet.size()) {
                    this.urlSet = NewLoaderLogic.applyBuiltinExcludes(this.urlSet, includeFilter);
                    if (this.filterSystemApps) {
                        this.urlSet = this.urlSet.exclude(".*/openejb-[^/]+(.(jar|ear|war)(!/)?|/target/(test-)?classes/?)");
                    }
                }
                if (!(isWindows = JavaSecurityManagers.getSystemProperty("os.name", "unknown").toLowerCase(Locale.ENGLISH).startsWith("windows")) || !Boolean.parseBoolean(SystemInstance.get().getProperty("openejb.resolver.windows.lowercase-urls", "true"))) {
                    this.urls = this.urlSet.getUrls();
                } else {
                    this.urls = new ArrayList<URL>();
                    for (URL url : this.urlSet.getUrls()) {
                        String ef = url.toExternalForm().toLowerCase();
                        URL u = new URL(ef);
                        if (this.urls.contains(u)) continue;
                        this.urls.add(u);
                    }
                }
                return this;
            }
            catch (IOException e1) {
                logger.warning("Unable to search classpath", e1);
                return this;
            }
        }
    }

    public static class DeploymentsConfigurationException
    extends RuntimeException {
        public DeploymentsConfigurationException(String message) {
            super(message);
        }
    }
}

