/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.DeploymentsResolver;
import org.apache.openejb.config.NameFiltering;
import org.apache.openejb.config.RequireDescriptors;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.PerformanceTimer;
import org.apache.openejb.util.URLs;
import org.apache.xbean.finder.UrlSet;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClasspathArchive;
import org.apache.xbean.finder.archive.FilteredArchive;
import org.apache.xbean.finder.filter.ExcludeIncludeFilter;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.Filters;
import org.apache.xbean.finder.filter.IncludeExcludeFilter;
import org.apache.xbean.finder.filter.PatternFilter;

public class NewLoaderLogic {
    private static final Logger logger = DeploymentLoader.LOGGER;
    public static final String DEFAULT_EXCLUSIONS_ALIAS = "default-list";
    public static final String ADDITIONAL_EXCLUDES = SystemInstance.get().getOptions().get("openejb.additional.exclude", (String)null);
    public static final String ADDITIONAL_INCLUDE = SystemInstance.get().getOptions().get("openejb.additional.include", (String)null);
    public static final String EXCLUSION_FILE = "exclusions.list";
    private static String[] exclusions;
    private static volatile Filter filter;

    public static UrlSet filterArchives(Filter filter, ClassLoader classLoader, UrlSet urlSet) {
        for (URL url : urlSet.getUrls()) {
            for (Archive archive : ClasspathArchive.archives((ClassLoader)classLoader, (URL[])new URL[]{url})) {
                FilteredArchive filtered = new FilteredArchive(archive, filter);
                if (filtered.iterator().hasNext()) continue;
                urlSet = urlSet.exclude(url);
            }
        }
        return urlSet;
    }

    public static Set<String> callers() {
        return NewLoaderLogic.callers(Filters.classes((String[])new String[]{"javax.ejb.embeddable.EJBContainer", "javax.naming.InitialContext"}));
    }

    public static Set<String> callers(Filter start) {
        StackTraceElement element;
        LinkedHashSet<String> callers = new LinkedHashSet<String>();
        ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>(Arrays.asList(new Exception().fillInStackTrace().getStackTrace()));
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            StackTraceElement element2 = (StackTraceElement)iterator.next();
            iterator.remove();
            if (!start.accept(element2.getClassName())) continue;
            while (iterator.hasNext() && element2.getClassName().equals(((StackTraceElement)iterator.next()).getClassName())) {
                iterator.remove();
            }
            break block0;
        }
        Filter end = Filters.packages((String[])new String[]{"junit.", "org.junit.", "org.testng.", "org.apache.maven.", "org.eclipse.", "com.intellij.", "org.scalatest."});
        Iterator iterator2 = elements.iterator();
        while (iterator2.hasNext() && !end.accept((element = (StackTraceElement)iterator2.next()).getClassName())) {
            callers.add(element.getClassName());
        }
        elements.clear();
        Filter unwanted = Filters.packages((String[])new String[]{"java.", "javax.", "jakarta.", "sun.reflect."});
        callers.removeIf(arg_0 -> ((Filter)unwanted).accept(arg_0));
        return callers;
    }

    public static UrlSet applyBuiltinExcludes(UrlSet urlSet) throws MalformedURLException {
        return NewLoaderLogic.applyBuiltinExcludes(urlSet, null);
    }

    public static UrlSet applyBuiltinExcludes(UrlSet urlSet, Filter includeFilter) throws MalformedURLException {
        return NewLoaderLogic.applyBuiltinExcludes(urlSet, includeFilter, null);
    }

    public static boolean skip(URL url) {
        return NewLoaderLogic.skip(url, null, null);
    }

    public static boolean skip(URL url, Filter includeFilter, Filter excludeFilter) {
        if ("archive".equals(url.getProtocol())) {
            return true;
        }
        try {
            File file = URLs.toFile(url);
            String name = NameFiltering.filter(file).getName();
            if (NewLoaderLogic.skip(includeFilter, excludeFilter, name)) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    private static boolean skip(Filter includeFilter, Filter excludeFilter, String name) {
        if (includeFilter == null || !includeFilter.accept(name)) {
            if (filter != null && filter.accept(name)) {
                return true;
            }
            if (excludeFilter != null && excludeFilter.accept(name)) {
                return true;
            }
        }
        return false;
    }

    public static boolean skip(String name) {
        NewLoaderLogic.getExclusions();
        return filter != null && filter.accept(name);
    }

    public static UrlSet applyBuiltinExcludes(UrlSet urlSet, Filter includeFilter, Filter excludeFilter) throws MalformedURLException {
        NewLoaderLogic.getExclusions();
        List urls = urlSet.getUrls();
        urls.removeIf(url -> NewLoaderLogic.skip(url, includeFilter, excludeFilter));
        return new UrlSet((Collection)urls);
    }

    @Deprecated
    public static void setExclusions(String[] exclusionArray) {
        exclusions = exclusionArray;
        filter = null;
        NewLoaderLogic.getFilter();
        NewLoaderLogic.logExclusions(exclusionArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void addAdditionalCustomFilter(final Filter excluded, final Filter included) {
        NewLoaderLogic.getExclusions();
        if (excluded != null && included != null) {
            Class<NewLoaderLogic> clazz = NewLoaderLogic.class;
            // MONITORENTER : org.apache.openejb.config.NewLoaderLogic.class
            final OptimizedExclusionFilter builtIn = new OptimizedExclusionFilter(NewLoaderLogic.getExclusions());
            filter = new Filter(){

                public boolean accept(String name) {
                    return !included.accept(name) && (builtIn.accept(name) || excluded.accept(name));
                }
            };
            // MONITOREXIT : clazz
        } else if (excluded != null) {
            Class<NewLoaderLogic> clazz = NewLoaderLogic.class;
            // MONITORENTER : org.apache.openejb.config.NewLoaderLogic.class
            final OptimizedExclusionFilter builtIn = new OptimizedExclusionFilter(NewLoaderLogic.getExclusions());
            filter = new Filter(){

                public boolean accept(String name) {
                    return builtIn.accept(name) || excluded.accept(name);
                }
            };
            // MONITOREXIT : clazz
        } else if (included != null) {
            Class<NewLoaderLogic> clazz = NewLoaderLogic.class;
            // MONITORENTER : org.apache.openejb.config.NewLoaderLogic.class
            final OptimizedExclusionFilter builtIn = new OptimizedExclusionFilter(NewLoaderLogic.getExclusions());
            filter = new Filter(){

                public boolean accept(String name) {
                    return !included.accept(name) && builtIn.accept(name);
                }
            };
            // MONITOREXIT : clazz
        }
        NewLoaderLogic.logExclusions(exclusions);
    }

    private static void logExclusions(String[] exclusionArray) {
        if (logger.isDebugEnabled()) {
            logger.debug("Exclusion prefixes: [");
            for (String ex : exclusionArray) {
                logger.debug("-" + ex);
            }
            logger.debug("]");
        }
    }

    public static String[] getExclusions() {
        if (exclusions != null) {
            return exclusions;
        }
        FileInputStream fis = null;
        try {
            File exclusionsFile = SystemInstance.get().getConf(EXCLUSION_FILE);
            if (exclusionsFile != null && exclusionsFile.exists()) {
                fis = new FileInputStream(exclusionsFile);
                exclusions = NewLoaderLogic.readInputStreamList(fis);
                logger.info("Loaded classpath exclusions from: " + exclusionsFile.getAbsolutePath());
            }
        }
        catch (Throwable exclusionsFile) {
        }
        finally {
            IO.close(fis);
        }
        if (exclusions == null) {
            exclusions = NewLoaderLogic.readDefaultExclusions();
        }
        ArrayList<String> excludes = new ArrayList<String>(exclusions.length + 5);
        excludes.addAll(Arrays.asList(exclusions));
        if (ADDITIONAL_EXCLUDES != null) {
            Collections.addAll(excludes, ADDITIONAL_EXCLUDES.split("[ \t\r\n]*,[ \t\n\n]*"));
        }
        if (ADDITIONAL_INCLUDE != null) {
            for (String rawInclude : ADDITIONAL_INCLUDE.split("[ \t\n\n]*,[ \t\n\n]*")) {
                String include = rawInclude.trim();
                excludes.removeIf(s -> s.startsWith(include));
            }
        }
        exclusions = excludes.toArray(new String[excludes.size()]);
        NewLoaderLogic.getFilter();
        NewLoaderLogic.logExclusions(exclusions);
        return exclusions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Filter getFilter() {
        if (filter != null) return filter;
        Class<NewLoaderLogic> clazz = NewLoaderLogic.class;
        synchronized (NewLoaderLogic.class) {
            if (filter != null) return filter;
            filter = new OptimizedExclusionFilter(NewLoaderLogic.getExclusions());
            // ** MonitorExit[var0] (shouldn't be in output)
            return filter;
        }
    }

    private static String[] readDefaultExclusions() {
        InputStream is = null;
        String[] read = null;
        try {
            is = NewLoaderLogic.class.getResourceAsStream("/default.exclusions");
            read = NewLoaderLogic.readInputStreamList(is);
            logger.debug("Loaded default.exclusions");
        }
        catch (Throwable throwable) {
        }
        finally {
            IO.close((Closeable)is);
        }
        return read;
    }

    public static String sanitize(String value) {
        if (value.endsWith("*.jar")) {
            return value.substring(0, value.length() - 5);
        }
        if (value.endsWith("*")) {
            return value.substring(0, value.length() - 1);
        }
        return value;
    }

    public static String[] readInputStreamList(InputStream is) {
        ArrayList<String> list = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = reader.readLine()) != null) {
                String value = line.trim();
                if (line.startsWith("#") || value.isEmpty()) continue;
                if (DEFAULT_EXCLUSIONS_ALIAS.equals(value)) {
                    Collections.addAll(list, NewLoaderLogic.readDefaultExclusions());
                    continue;
                }
                list.add(NewLoaderLogic.sanitize(value));
            }
        }
        catch (Throwable e) {
            logger.warning("readInputStreamList: Failed to read provided stream");
        }
        return list.toArray(new String[list.size()]);
    }

    public static void _loadFromClasspath(FileUtils base, List<URL> jarList, ClassLoader classLoader) {
        IncludeExcludeFilter packageFilter;
        PerformanceTimer timer = new PerformanceTimer();
        timer.event("create filters");
        Options options = SystemInstance.get().getOptions();
        String include = "";
        String exclude = "";
        PatternFilter classpathInclude = new PatternFilter(options.get("openejb.deployments.classpath.include", ".*"));
        PatternFilter classpathExclude = new PatternFilter(options.get("openejb.deployments.classpath.exclude", ""));
        ExcludeIncludeFilter classpathFilter = new ExcludeIncludeFilter((Filter)classpathInclude, (Filter)classpathExclude);
        PatternFilter packageInclude = new PatternFilter(options.get("openejb.deployments.package.include", ".*"));
        PatternFilter packageExclude = new PatternFilter(options.get("openejb.deployments.package.exclude", ""));
        if (classpathInclude.getPattern().pattern().equals(".*") && packageInclude.getPattern().pattern().equals(".*")) {
            timer.event("callers");
            Set<String> callers = NewLoaderLogic.callers();
            timer.event("parse packages");
            callers.size();
            HashSet<String> packages = new HashSet<String>();
            for (String caller : callers) {
                Object parts = caller.split("\\.");
                if (((String[])parts).length > 2) {
                    parts = new String[]{parts[0], parts[1]};
                }
                packages.add(Join.join(".", (Object[])parts));
            }
            Filter includes = Filters.packages((String[])packages.toArray(new String[packages.size()]));
            packageFilter = new IncludeExcludeFilter(includes, (Filter)packageExclude);
        } else {
            packageFilter = new IncludeExcludeFilter((Filter)packageInclude, (Filter)packageExclude);
        }
        timer.event("urlset");
        Set requireDescriptors = options.getAll("openejb.deployments.classpath.require.descriptor", (Enum[])new RequireDescriptors[]{RequireDescriptors.CLIENT});
        try {
            boolean userSuppliedClasspathFilter;
            UrlSet urlSet = new UrlSet(classLoader);
            timer.event("exclude system urls");
            urlSet = URLs.cullSystemJars(urlSet);
            timer.event("classpath filter");
            UrlSet beforeFiltering = urlSet;
            urlSet = urlSet.filter((Filter)classpathFilter);
            if (urlSet.size() == 0) {
                String message = String.format("Classpath Include/Exclude resulted in zero URLs.  There were %s possible URLs before filtering and 0 after: include=\"%s\", exclude=\"%s\"", beforeFiltering.size(), "", "");
                logger.error(message);
                logger.info("Eligible Classpath before filtering:");
                for (URL url : beforeFiltering) {
                    logger.info(String.format("   %s", url.toExternalForm()));
                }
            }
            boolean bl = userSuppliedClasspathFilter = beforeFiltering.size() != urlSet.size();
            if (!userSuppliedClasspathFilter) {
                logger.info("Applying buildin classpath excludes");
                timer.event("buildin excludes");
                urlSet = NewLoaderLogic.applyBuiltinExcludes(urlSet);
            }
            DeploymentsResolver.processUrls("NewLoaderLogic1", urlSet.getUrls(), classLoader, EnumSet.allOf(RequireDescriptors.class), base, jarList);
            timer.event("package filter");
            urlSet = NewLoaderLogic.filterArchives((Filter)packageFilter, classLoader, urlSet);
            timer.event("process urls");
            List urls = urlSet.getUrls();
            long begin = System.currentTimeMillis();
            DeploymentsResolver.processUrls("NewLoaderLogic2", urls, classLoader, requireDescriptors, base, jarList);
            long end = System.currentTimeMillis();
            long time = end - begin;
            timer.stop(System.out);
            UrlSet unchecked = new UrlSet(new URL[0]);
            DeploymentsResolver.processUrls("NewLoaderLogic3", unchecked.getUrls(), classLoader, EnumSet.allOf(RequireDescriptors.class), base, jarList);
            if (logger.isDebugEnabled()) {
                int urlCount = urlSet.getUrls().size() + unchecked.getUrls().size();
                logger.debug("URLs after filtering: " + urlCount);
                for (URL uRL : urlSet.getUrls()) {
                    logger.debug("Annotations path: " + uRL);
                }
                for (URL uRL : unchecked.getUrls()) {
                    logger.debug("Descriptors path: " + uRL);
                }
            }
            if (urls.size() == 0) {
                return;
            }
            if (time < 1000L) {
                logger.debug("Searched " + urls.size() + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urls.size() + " milliseconds per url.");
            } else if (time < 4000L || urls.size() < 3) {
                logger.info("Searched " + urls.size() + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urls.size() + " milliseconds per url.");
            } else if (time < 10000L) {
                logger.warning("Searched " + urls.size() + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urls.size() + " milliseconds per url.");
                logger.warning("Consider adjusting your openejb.deployments.classpath.exclude and openejb.deployments.classpath.include settings.  Current settings: exclude='', include=''");
            } else {
                logger.fatal("Searched " + urls.size() + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urls.size() + " milliseconds per url.  TOO LONG!");
                logger.fatal("ADJUST THE EXCLUDE/INCLUDE!!!.  Current settings: openejb.deployments.classpath.exclude='', openejb.deployments.classpath.include=''");
                ArrayList<String> list = new ArrayList<String>();
                for (URL uRL : urls) {
                    list.add(uRL.toExternalForm());
                }
                Collections.sort(list);
                for (String string : list) {
                    logger.info("Matched: " + string);
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            logger.warning("Unable to search classpath for modules: Received Exception: " + e1.getClass().getName() + " " + e1.getMessage(), e1);
        }
    }

    public static class OptimizedExclusionFilter
    implements Filter {
        private final Set<String> included = new HashSet<String>();

        public OptimizedExclusionFilter(String[] exclusions) {
            this.included.addAll(Arrays.asList(exclusions));
            for (String e : exclusions) {
                if (!e.endsWith("-")) continue;
                this.included.add(e.substring(0, e.length() - 1) + ".jar");
            }
        }

        public boolean accept(String name) {
            for (int i = 1; i <= name.length(); ++i) {
                if (!this.included.contains(name.substring(0, i))) continue;
                return true;
            }
            return false;
        }
    }
}

