/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.security.jaas;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.openejb.AppContext;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.inject.OWBInjector;

public class CDILoginModule
implements LoginModule {
    private CreationalContextImpl<?> cc;
    private LoginModule loginModule;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        Class<?> clazz;
        String app;
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        BeanManagerImpl bm = webBeansContext.getBeanManagerImpl();
        if (!bm.isInUse()) {
            throw new OpenEJBRuntimeException("CDI not activated");
        }
        String delegate = String.valueOf(options.get("delegate"));
        if ("null".equals(delegate) && "null".equals(delegate = String.valueOf(options.get(app = CDILoginModule.findAppName(webBeansContext))))) {
            throw new OpenEJBRuntimeException("Please specify a delegate class");
        }
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(delegate);
        }
        catch (ClassNotFoundException e) {
            throw new OpenEJBRuntimeException(e.getMessage(), e);
        }
        this.cc = bm.createCreationalContext(null);
        String cdiName = String.valueOf(options.get("cdiName"));
        if ("true".equals(String.valueOf(options.get("loginModuleAsCdiBean")))) {
            Set beans = "null".equals(cdiName) ? bm.getBeans(clazz, new Annotation[0]) : bm.getBeans(cdiName);
            this.loginModule = (LoginModule)LoginModule.class.cast(bm.getReference(bm.resolve(beans), clazz, this.cc));
        } else {
            try {
                this.loginModule = (LoginModule)LoginModule.class.cast(clazz.newInstance());
                OWBInjector.inject((BeanManager)bm, (Object)this.loginModule, this.cc);
            }
            catch (Exception e) {
                throw new OpenEJBRuntimeException("Can't inject into delegate class " + this.loginModule, e);
            }
        }
        this.loginModule.initialize(subject, callbackHandler, sharedState, options);
    }

    private static String findAppName(WebBeansContext webBeansContext) {
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        for (AppContext appContext : containerSystem.getAppContexts()) {
            if (appContext.getWebBeansContext() == webBeansContext) {
                return appContext.getId();
            }
            for (WebContext web : appContext.getWebContexts()) {
                if (web.getWebbeansContext() != webBeansContext) continue;
                return web.getId();
            }
        }
        return "defaultDelegate";
    }

    @Override
    public boolean login() throws LoginException {
        return this.loginModule != null && this.loginModule.login();
    }

    @Override
    public boolean commit() throws LoginException {
        return this.loginModule == null || this.loginModule.commit();
    }

    @Override
    public boolean abort() throws LoginException {
        try {
            boolean bl = this.loginModule == null || this.loginModule.abort();
            return bl;
        }
        finally {
            this.cleanUp();
        }
    }

    @Override
    public boolean logout() throws LoginException {
        try {
            boolean bl = this.loginModule == null || this.loginModule.logout();
            return bl;
        }
        finally {
            this.cleanUp();
        }
    }

    private void cleanUp() {
        if (this.cc != null) {
            this.cc.release();
            this.cc = null;
        }
    }
}

