/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import jakarta.persistence.Cache;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.Query;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.SynchronizationType;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import javax.naming.NamingException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.api.internal.Internal;
import org.apache.openejb.api.jmx.Description;
import org.apache.openejb.api.jmx.MBean;
import org.apache.openejb.api.jmx.ManagedAttribute;
import org.apache.openejb.api.jmx.ManagedOperation;
import org.apache.openejb.assembler.classic.EntityManagerFactoryCallable;
import org.apache.openejb.jee.JAXBContextFactory;
import org.apache.openejb.jee.Persistence;
import org.apache.openejb.jee.PersistenceUnitCaching;
import org.apache.openejb.jee.PersistenceUnitValidationMode;
import org.apache.openejb.jpa.integration.JPAThreadContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.DynamicMBeanWrapper;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.monitoring.ObjectNameBuilder;
import org.apache.openejb.persistence.PersistenceUnitInfoImpl;
import org.apache.openejb.persistence.QueryLogEntityManager;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

@Internal
public class ReloadableEntityManagerFactory
implements EntityManagerFactory,
Serializable {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB, ReloadableEntityManagerFactory.class);
    public static final String JAKARTA_PERSISTENCE_SHARED_CACHE_MODE = "jakarta.persistence.sharedCache.mode";
    public static final String JAKARTA_PERSISTENCE_VALIDATION_MODE = "jakarta.persistence.validation.mode";
    public static final String JAKARTA_PERSISTENCE_TRANSACTION_TYPE = "jakarta.persistence.transactionType";
    public static final String OPENEJB_JPA_CRITERIA_LOG_JPQL = "openejb.jpa.criteria.log.jpql";
    public static final String OPENEJB_JPA_CRITERIA_LOG_JPQL_LEVEL = "openejb.jpa.criteria.log.jpql.level";
    private final PersistenceUnitInfoImpl unitInfoImpl;
    private ClassLoader classLoader;
    private volatile EntityManagerFactory delegate;
    private final EntityManagerFactoryCallable entityManagerFactoryCallable;
    private ObjectName objectName;
    private final boolean logCriteriaJpql;
    private final String logCriteriaJpqlLevel;

    public ReloadableEntityManagerFactory(ClassLoader cl, EntityManagerFactoryCallable callable, PersistenceUnitInfoImpl unitInfo) {
        this.classLoader = cl;
        this.entityManagerFactoryCallable = callable;
        this.unitInfoImpl = unitInfo;
        Properties properties = unitInfo.getProperties();
        this.logCriteriaJpql = this.logCriteriaQueryJpql(properties);
        this.logCriteriaJpqlLevel = this.logCriteriaQueryJpqlLevel(properties);
        if (!callable.getUnitInfo().isLazilyInitialized()) {
            this.createDelegate();
        }
    }

    public void overrideClassLoader(ClassLoader loader) {
        this.classLoader = loader;
        this.entityManagerFactoryCallable.overrideClassLoader(loader);
        this.unitInfoImpl.setClassLoader(loader);
    }

    public EntityManagerFactoryCallable getEntityManagerFactoryCallable() {
        return this.entityManagerFactoryCallable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityManagerFactory delegate() {
        if (this.delegate == null) {
            ReloadableEntityManagerFactory reloadableEntityManagerFactory = this;
            synchronized (reloadableEntityManagerFactory) {
                if (this.delegate == null) {
                    this.createDelegate();
                }
            }
        }
        return this.delegate;
    }

    public void createDelegate() {
        long time;
        JPAThreadContext.infos.put("properties", this.entityManagerFactoryCallable.getUnitInfo().getProperties());
        long start = System.nanoTime();
        try {
            this.delegate = this.entityManagerFactoryCallable.call();
            time = TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
        catch (Exception e) {
            try {
                throw new OpenEJBRuntimeException(e);
            }
            catch (Throwable throwable) {
                long time2 = TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS);
                LOGGER.info("assembler.buildingPersistenceUnit", this.unitInfoImpl.getPersistenceUnitName(), this.unitInfoImpl.getPersistenceProviderClassName(), String.valueOf(time2));
                if (LOGGER.isDebugEnabled()) {
                    for (Map.Entry<Object, Object> entry : this.unitInfoImpl.getProperties().entrySet()) {
                        LOGGER.debug(entry.getKey() + "=" + entry.getValue());
                    }
                }
                JPAThreadContext.infos.clear();
                throw throwable;
            }
        }
        LOGGER.info("assembler.buildingPersistenceUnit", this.unitInfoImpl.getPersistenceUnitName(), this.unitInfoImpl.getPersistenceProviderClassName(), String.valueOf(time));
        if (LOGGER.isDebugEnabled()) {
            for (Map.Entry<Object, Object> entry : this.unitInfoImpl.getProperties().entrySet()) {
                LOGGER.debug(entry.getKey() + "=" + entry.getValue());
            }
        }
        JPAThreadContext.infos.clear();
    }

    private String logCriteriaQueryJpqlLevel(Properties props) {
        return SystemInstance.get().getOptions().get(OPENEJB_JPA_CRITERIA_LOG_JPQL_LEVEL, props.getProperty(OPENEJB_JPA_CRITERIA_LOG_JPQL_LEVEL, "INFO"));
    }

    private boolean logCriteriaQueryJpql(Properties prop) {
        return SystemInstance.get().getOptions().get(OPENEJB_JPA_CRITERIA_LOG_JPQL, Boolean.parseBoolean(prop.getProperty(OPENEJB_JPA_CRITERIA_LOG_JPQL, "false"))) || SystemInstance.get().getOptions().get(OPENEJB_JPA_CRITERIA_LOG_JPQL_LEVEL, prop.getProperty(OPENEJB_JPA_CRITERIA_LOG_JPQL_LEVEL, null)) != null;
    }

    public EntityManager createEntityManager() {
        EntityManager em;
        try {
            em = this.delegate().createEntityManager();
        }
        catch (LinkageError le) {
            em = this.delegate.createEntityManager();
        }
        if (this.logCriteriaJpql) {
            return new QueryLogEntityManager(em, this.logCriteriaJpqlLevel);
        }
        return em;
    }

    public EntityManager createEntityManager(Map map) {
        EntityManager em;
        try {
            em = this.delegate().createEntityManager(map);
        }
        catch (LinkageError le) {
            em = this.delegate.createEntityManager(map);
        }
        if (this.logCriteriaJpql) {
            return new QueryLogEntityManager(em, this.logCriteriaJpqlLevel);
        }
        return em;
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType) {
        EntityManager em;
        try {
            em = this.delegate().createEntityManager(synchronizationType);
        }
        catch (LinkageError le) {
            em = this.delegate.createEntityManager(synchronizationType);
        }
        if (this.logCriteriaJpql) {
            return new QueryLogEntityManager(em, this.logCriteriaJpqlLevel);
        }
        return em;
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType, Map map) {
        EntityManager em;
        try {
            em = this.delegate().createEntityManager(synchronizationType, map);
        }
        catch (LinkageError le) {
            em = this.delegate.createEntityManager(synchronizationType, map);
        }
        if (this.logCriteriaJpql) {
            return new QueryLogEntityManager(em, this.logCriteriaJpqlLevel);
        }
        return em;
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isAssignableFrom(this.getClass())) {
            return cls.cast(this);
        }
        return (T)this.delegate().unwrap(cls);
    }

    public void addNamedQuery(String name, Query query) {
        this.delegate().addNamedQuery(name, query);
    }

    public <T> void addNamedEntityGraph(String graphName, EntityGraph<T> entityGraph) {
        this.delegate().addNamedEntityGraph(graphName, entityGraph);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.delegate().getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.delegate().getMetamodel();
    }

    public boolean isOpen() {
        return this.delegate().isOpen();
    }

    public synchronized void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    public Map<String, Object> getProperties() {
        return this.delegate().getProperties();
    }

    public Cache getCache() {
        return this.delegate().getCache();
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.delegate().getPersistenceUnitUtil();
    }

    public EntityManagerFactory getDelegate() {
        return this.delegate();
    }

    public void register() throws OpenEJBException {
        if (!LocalMBeanServer.isJMXActive()) {
            return;
        }
        MBeanServer server = LocalMBeanServer.get();
        try {
            this.generateObjectName();
            if (server.isRegistered(this.objectName)) {
                server.unregisterMBean(this.objectName);
            }
            server.registerMBean(this.mBeanify(), this.objectName);
        }
        catch (Exception e) {
            throw new OpenEJBException("can't register the mbean for the entity manager factory " + this.getPUname(), e);
        }
        catch (NoClassDefFoundError ncdfe) {
            this.objectName = null;
            LOGGER.error("can't register the mbean for the entity manager factory {0}", this.getPUname());
        }
    }

    private ObjectName generateObjectName() {
        ObjectNameBuilder jmxName = new ObjectNameBuilder("openejb.management");
        jmxName.set("ObjectType", "persistence-unit");
        jmxName.set("PersistenceUnit", this.getPUname());
        this.objectName = jmxName.build();
        MBeanServer server = LocalMBeanServer.get();
        if (server.isRegistered(this.objectName)) {
            jmxName.set("PersistenceUnit", this.getPUname() + "(" + this.getId() + ")");
            this.objectName = jmxName.build();
        }
        return this.objectName;
    }

    private String getPUname() {
        return this.entityManagerFactoryCallable.getUnitInfo().getPersistenceUnitName();
    }

    private String getId() {
        return this.entityManagerFactoryCallable.getUnitInfo().getId();
    }

    private Object mBeanify() {
        return new DynamicMBeanWrapper(new JMXReloadableEntityManagerFactory(this));
    }

    public void unregister() throws OpenEJBException {
        if (this.objectName != null) {
            MBeanServer server = LocalMBeanServer.get();
            try {
                server.unregisterMBean(this.objectName);
            }
            catch (Exception e) {
                throw new OpenEJBException("can't unregister the mbean for the entity manager factory " + this.getPUname(), e);
            }
        }
    }

    public synchronized void reload() {
        try {
            this.createDelegate();
        }
        catch (Exception e) {
            LOGGER.error("can't replace EntityManagerFactory " + this.delegate, e);
        }
    }

    public synchronized void setSharedCacheMode(SharedCacheMode mode) {
        PersistenceUnitInfoImpl info = this.entityManagerFactoryCallable.getUnitInfo();
        info.setSharedCacheMode(mode);
        Properties properties = this.entityManagerFactoryCallable.getUnitInfo().getProperties();
        if (properties.containsKey(JAKARTA_PERSISTENCE_SHARED_CACHE_MODE)) {
            properties.setProperty(JAKARTA_PERSISTENCE_SHARED_CACHE_MODE, mode.name());
        }
    }

    public synchronized void setValidationMode(ValidationMode mode) {
        PersistenceUnitInfoImpl info = this.entityManagerFactoryCallable.getUnitInfo();
        info.setValidationMode(mode);
        Properties properties = this.entityManagerFactoryCallable.getUnitInfo().getProperties();
        if (properties.containsKey(JAKARTA_PERSISTENCE_VALIDATION_MODE)) {
            properties.setProperty(JAKARTA_PERSISTENCE_VALIDATION_MODE, mode.name());
        }
    }

    public synchronized void setProvider(String providerRaw) {
        String newProvider;
        String provider;
        switch (provider = providerRaw.trim()) {
            case "hibernate": {
                newProvider = "org.hibernate.ejb.HibernatePersistence";
                break;
            }
            case "openjpa": {
                newProvider = "org.apache.openjpa.persistence.PersistenceProviderImpl";
                break;
            }
            case "eclipselink": {
                newProvider = "org.eclipse.persistence.jpa.PersistenceProvider";
                break;
            }
            case "toplink": {
                newProvider = "oracle.toplink.essentials.PersistenceProvider";
                break;
            }
            default: {
                newProvider = provider;
            }
        }
        try {
            this.classLoader.loadClass(newProvider);
            this.entityManagerFactoryCallable.getUnitInfo().setPersistenceProviderClassName(newProvider);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("can't load new provider " + newProvider, e);
        }
    }

    public synchronized void setTransactionType(PersistenceUnitTransactionType type) {
        PersistenceUnitInfoImpl info = this.entityManagerFactoryCallable.getUnitInfo();
        info.setTransactionType(type);
        Properties properties = this.entityManagerFactoryCallable.getUnitInfo().getProperties();
        if (properties.containsKey(JAKARTA_PERSISTENCE_TRANSACTION_TYPE)) {
            properties.setProperty(JAKARTA_PERSISTENCE_TRANSACTION_TYPE, type.name());
        }
    }

    public synchronized void setProperty(String key, String value) {
        PersistenceUnitInfoImpl unitInfo = this.entityManagerFactoryCallable.getUnitInfo();
        if (unitInfo.getProperties() == null) {
            unitInfo.setProperties(new Properties());
        }
        unitInfo.getProperties().setProperty(key, value);
    }

    public synchronized void removeProperty(String key) {
        PersistenceUnitInfoImpl unitInfo = this.entityManagerFactoryCallable.getUnitInfo();
        if (unitInfo.getProperties() != null) {
            unitInfo.getProperties().remove(key);
        }
    }

    public Properties getUnitProperties() {
        PersistenceUnitInfoImpl unitInfo = this.entityManagerFactoryCallable.getUnitInfo();
        if (unitInfo.getProperties() != null) {
            return unitInfo.getProperties();
        }
        return new Properties();
    }

    public List<String> getMappingFiles() {
        return this.entityManagerFactoryCallable.getUnitInfo().getMappingFileNames();
    }

    public void addMappingFile(String file) {
        if (new File(file).exists()) {
            this.entityManagerFactoryCallable.getUnitInfo().addMappingFileName(file);
        } else {
            LOGGER.error("file " + file + " doesn't exists");
        }
    }

    public void removeMappingFile(String file) {
        this.entityManagerFactoryCallable.getUnitInfo().getMappingFileNames().remove(file);
    }

    public List<URL> getJarFileUrls() {
        return this.entityManagerFactoryCallable.getUnitInfo().getJarFileUrls();
    }

    public void addJarFileUrls(String file) {
        if (new File(file).exists()) {
            try {
                this.entityManagerFactoryCallable.getUnitInfo().getJarFileUrls().add(new URL(file));
            }
            catch (MalformedURLException e) {
                LOGGER.error("url " + file + " is malformed");
            }
        } else {
            LOGGER.error("url " + file + " is not correct");
        }
    }

    public void removeJarFileUrls(String file) {
        try {
            this.entityManagerFactoryCallable.getUnitInfo().getJarFileUrls().remove(new URL(file));
        }
        catch (MalformedURLException e) {
            LOGGER.error("url " + file + " is malformed");
        }
    }

    public List<String> getManagedClasses() {
        return this.entityManagerFactoryCallable.getUnitInfo().getManagedClassNames();
    }

    public void addManagedClasses(String clazz) {
        this.entityManagerFactoryCallable.getUnitInfo().getManagedClassNames().add(clazz);
    }

    public void removeManagedClasses(String clazz) {
        this.entityManagerFactoryCallable.getUnitInfo().getManagedClassNames().remove(clazz);
    }

    public PersistenceUnitInfo info() {
        return this.entityManagerFactoryCallable.getUnitInfo();
    }

    public void setExcludeUnlistedClasses(boolean excludeUnlistedClasses) {
        this.entityManagerFactoryCallable.getUnitInfo().setExcludeUnlistedClasses(excludeUnlistedClasses);
    }

    public boolean getExcludeUnlistedClasses() {
        return this.entityManagerFactoryCallable.getUnitInfo().excludeUnlistedClasses();
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializableEm("java:openejb/PersistenceUnit/" + this.unitInfoImpl.getId());
    }

    private static final class SerializableEm
    implements Serializable {
        private final String jndiName;

        private SerializableEm(String jndiName) {
            this.jndiName = jndiName;
        }

        Object readResolve() throws ObjectStreamException {
            try {
                return ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getJNDIContext().lookup(this.jndiName);
            }
            catch (NamingException e) {
                throw new InvalidObjectException(e.getMessage());
            }
        }
    }

    @MBean
    @Internal
    @Description(value="represents a persistence unit managed by OpenEJB")
    public static class JMXReloadableEntityManagerFactory {
        private final ReloadableEntityManagerFactory reloadableEntityManagerFactory;

        public JMXReloadableEntityManagerFactory(ReloadableEntityManagerFactory remf) {
            this.reloadableEntityManagerFactory = remf;
        }

        @ManagedOperation
        @Description(value="recreate the entity manager factory using new properties")
        public void reload() {
            this.reloadableEntityManagerFactory.reload();
        }

        @ManagedOperation
        @Description(value="change the current JPA provider")
        public void setProvider(String provider) {
            this.reloadableEntityManagerFactory.setProvider(provider);
        }

        @ManagedOperation
        @Description(value="change the current transaction type")
        public void setTransactionType(String type) {
            try {
                PersistenceUnitTransactionType tt = PersistenceUnitTransactionType.valueOf((String)type.toUpperCase());
                this.reloadableEntityManagerFactory.setTransactionType(tt);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @ManagedOperation
        @Description(value="create or modify a property of the persistence unit")
        public void setProperty(String key, String value) {
            this.reloadableEntityManagerFactory.setProperty(key, value);
        }

        @ManagedOperation
        @Description(value="remove a property of the persistence unit if it exists")
        public void removeProperty(String key) {
            this.reloadableEntityManagerFactory.removeProperty(key);
        }

        @ManagedOperation
        @Description(value="add a mapping file")
        public void addMappingFile(String file) {
            this.reloadableEntityManagerFactory.addMappingFile(file);
        }

        @ManagedOperation
        @Description(value="remove a mapping file")
        public void removeMappingFile(String file) {
            this.reloadableEntityManagerFactory.removeMappingFile(file);
        }

        @ManagedOperation
        @Description(value="add a managed class")
        public void addManagedClass(String clazz) {
            this.reloadableEntityManagerFactory.addManagedClasses(clazz);
        }

        @ManagedOperation
        @Description(value="remove a managed class")
        public void removeManagedClass(String clazz) {
            this.reloadableEntityManagerFactory.removeManagedClasses(clazz);
        }

        @ManagedOperation
        @Description(value="add a jar file")
        public void addJarFile(String file) {
            this.reloadableEntityManagerFactory.addJarFileUrls(file);
        }

        @ManagedOperation
        @Description(value="remove a jar file")
        public void removeJarFile(String file) {
            this.reloadableEntityManagerFactory.removeJarFileUrls(file);
        }

        @ManagedOperation
        @Description(value="change the shared cache mode if possible (value is ok)")
        public void setSharedCacheMode(String value) {
            try {
                String v = value.trim().toUpperCase();
                SharedCacheMode mode = v.isEmpty() ? SharedCacheMode.UNSPECIFIED : SharedCacheMode.valueOf((String)v);
                this.reloadableEntityManagerFactory.setSharedCacheMode(mode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @ManagedOperation
        @Description(value="exclude or not unlisted entities")
        public void setExcludeUnlistedClasses(boolean value) {
            this.reloadableEntityManagerFactory.setExcludeUnlistedClasses(value);
        }

        @ManagedOperation
        @Description(value="change the validation mode if possible (value is ok)")
        public void setValidationMode(String value) {
            try {
                ValidationMode mode = ValidationMode.valueOf((String)value.trim().toUpperCase());
                this.reloadableEntityManagerFactory.setValidationMode(mode);
            }
            catch (Exception iae) {
                LOGGER.warning("Can't set validation mode " + value, iae);
                this.reloadableEntityManagerFactory.setProperty(ReloadableEntityManagerFactory.JAKARTA_PERSISTENCE_VALIDATION_MODE, value);
            }
        }

        @ManagedOperation
        @Description(value="dump the current configuration for this persistence unit in a file")
        public void dump(String file) {
            PersistenceUnitInfoImpl info = this.reloadableEntityManagerFactory.entityManagerFactoryCallable.getUnitInfo();
            Persistence.PersistenceUnit pu = new Persistence.PersistenceUnit();
            pu.setJtaDataSource(info.getJtaDataSourceName());
            pu.setNonJtaDataSource(info.getNonJtaDataSourceName());
            pu.getClazz().addAll(info.getManagedClassNames());
            pu.getMappingFile().addAll(info.getMappingFileNames());
            pu.setName(info.getPersistenceUnitName());
            pu.setProvider(info.getPersistenceProviderClassName());
            pu.setTransactionType(info.getTransactionType().name());
            pu.setExcludeUnlistedClasses(Boolean.valueOf(info.excludeUnlistedClasses()));
            pu.setSharedCacheMode(PersistenceUnitCaching.fromValue((String)info.getSharedCacheMode().name()));
            pu.setValidationMode(PersistenceUnitValidationMode.fromValue((String)info.getValidationMode().name()));
            for (URL url : info.getJarFileUrls()) {
                pu.getJarFile().add(url.toString());
            }
            for (String key : info.getProperties().stringPropertyNames()) {
                Persistence.PersistenceUnit.Properties.Property prop = new Persistence.PersistenceUnit.Properties.Property();
                prop.setName(key);
                prop.setValue(info.getProperties().getProperty(key));
                if (pu.getProperties() == null) {
                    pu.setProperties(new Persistence.PersistenceUnit.Properties());
                }
                pu.getProperties().getProperty().add(prop);
            }
            Persistence persistence = new Persistence();
            persistence.setVersion(info.getPersistenceXMLSchemaVersion());
            persistence.getPersistenceUnit().add(pu);
            try (FileWriter writer = new FileWriter(file);){
                JAXBContext jc = JAXBContextFactory.newInstance((Class[])new Class[]{Persistence.class});
                Marshaller marshaller = jc.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                marshaller.marshal((Object)persistence, (Writer)writer);
            }
            catch (Exception e) {
                LOGGER.error("can't dump pu " + this.reloadableEntityManagerFactory.getPUname() + " in file " + file, e);
            }
        }

        @ManagedAttribute
        @Description(value="get exclude unlisted classes")
        public boolean getExcludeUnlistedClasses() {
            return this.reloadableEntityManagerFactory.getExcludeUnlistedClasses();
        }

        @ManagedAttribute
        @Description(value="get all properties")
        public TabularData getProperties() {
            return LocalMBeanServer.tabularData("properties", "properties type", "Property of " + this.reloadableEntityManagerFactory.getPUname(), this.reloadableEntityManagerFactory.getUnitProperties());
        }

        @ManagedAttribute
        @Description(value="get all mapping files")
        public TabularData getMappingFiles() {
            return this.buildTabularData("mappingfile", "mapping file type", this.reloadableEntityManagerFactory.getMappingFiles(), Info.FILE);
        }

        @ManagedAttribute
        @Description(value="get all jar files")
        public TabularData getJarFiles() {
            return this.buildTabularData("jarfile", "jar file type", this.reloadableEntityManagerFactory.getJarFileUrls(), Info.URL);
        }

        @ManagedAttribute
        @Description(value="get all managed classes")
        public TabularData getManagedClasses() {
            return this.buildTabularData("managedclass", "managed class type", this.reloadableEntityManagerFactory.getManagedClasses(), Info.CLASS);
        }

        private TabularData buildTabularData(String typeName, String typeDescription, List<?> list, Info info) {
            String[] names = new String[list.size()];
            Object[] values = new Object[names.length];
            int i = 0;
            for (Object o : list) {
                names[i] = o.toString();
                values[i++] = info.info(this.reloadableEntityManagerFactory.classLoader, o);
            }
            return LocalMBeanServer.tabularData(typeName, typeDescription, names, values);
        }

        private static enum Info {
            URL,
            NONE,
            FILE,
            CLASS;


            public String info(ClassLoader cl, Object o) {
                switch (this) {
                    case URL: {
                        try {
                            if (((URL)o).openConnection().getContentLength() > 0) {
                                return "valid";
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return "not valid";
                    }
                    case FILE: {
                        File file;
                        if (o instanceof String) {
                            file = new File((String)o);
                        } else if (o instanceof File) {
                            file = (File)o;
                        } else {
                            return "unknown";
                        }
                        return "exist? " + file.exists();
                    }
                    case CLASS: {
                        try {
                            cl.loadClass((String)o);
                            return "loaded";
                        }
                        catch (ClassNotFoundException e) {
                            return "unloadable";
                        }
                    }
                }
                return "-";
            }
        }
    }
}

