/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi.transactional;

import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionScoped;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.apache.geronimo.transaction.manager.GeronimoTransactionManager;
import org.apache.geronimo.transaction.manager.TransactionImpl;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.loader.SystemInstance;
import org.apache.webbeans.context.AbstractContext;
import org.apache.webbeans.context.creational.BeanInstanceBag;

public class TransactionContext
extends AbstractContext
implements Synchronization {
    private static final Class<?>[] MAP = new Class[]{Map.class};
    private final TransactionManager transactionManager = OpenEJB.getTransactionManager();
    private final boolean geronimoTxMgr = GeronimoTransactionManager.class.isInstance(OpenEJB.getTransactionManager());

    public TransactionContext() {
        super(TransactionScoped.class);
    }

    public boolean isActive() {
        try {
            int status = this.transactionManager.getTransaction().getStatus();
            return status == 0 || status == 1 || status == 2 || status == 7 || status == 8 || status == 9 || status == 5;
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected void checkActive() {
        if (!this.isActive()) {
            throw new ContextNotActiveException("Context with scope annotation @" + this.getScope().getName() + " is not active");
        }
    }

    protected void setComponentInstanceMap() {
        this.componentInstanceMap = (Map)Map.class.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), MAP, (InvocationHandler)new TransactionalMapHandler(this, (TransactionSynchronizationRegistry)SystemInstance.get().getComponent(TransactionSynchronizationRegistry.class))));
    }

    public void beforeCompletion() {
        if (!this.geronimoTxMgr) {
            this.destroy();
        }
    }

    public void afterCompletion(int status) {
        if (this.geronimoTxMgr) {
            this.destroy();
        }
    }

    private static class TransactionalMapHandler
    implements InvocationHandler {
        private static final String KEY = "@Transactional#OpenEJB.map";
        private final TransactionSynchronizationRegistry registry;
        private final TransactionContext context;

        public TransactionalMapHandler(TransactionContext transactionContext, TransactionSynchronizationRegistry registry) {
            this.context = transactionContext;
            this.registry = registry;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke(this.findMap(), args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }

        private Map<Contextual<?>, BeanInstanceBag<?>> findMap() {
            Object resource;
            try {
                resource = this.context.geronimoTxMgr ? ((TransactionImpl)TransactionImpl.class.cast(this.context.transactionManager.getTransaction())).getResource((Object)KEY) : this.registry.getResource((Object)KEY);
            }
            catch (SystemException e) {
                throw new IllegalStateException(e);
            }
            if (resource == null) {
                HashMap map = new HashMap();
                this.registry.putResource((Object)KEY, map);
                this.registry.registerInterposedSynchronization((Synchronization)this.context);
                return map;
            }
            return (Map)Map.class.cast(resource);
        }
    }
}

