/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.mdb;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.UnavailableException;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.NamingException;
import javax.transaction.xa.XAResource;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.ContainerType;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.ExceptionType;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.InterceptorStack;
import org.apache.openejb.core.mdb.BaseMdbContainer;
import org.apache.openejb.core.mdb.EndpointFactory;
import org.apache.openejb.core.mdb.InboundRecovery;
import org.apache.openejb.core.mdb.Instance;
import org.apache.openejb.core.mdb.MdbInstanceFactory;
import org.apache.openejb.core.timer.EjbTimerService;
import org.apache.openejb.core.transaction.EjbTransactionUtil;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.monitoring.Managed;
import org.apache.openejb.monitoring.ManagedMBean;
import org.apache.openejb.monitoring.ObjectNameBuilder;
import org.apache.openejb.monitoring.StatsInterceptor;
import org.apache.openejb.resource.XAResourceWrapper;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

public class MdbContainer
implements RpcContainer,
BaseMdbContainer {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private static final ThreadLocal<BeanContext> CURRENT = new ThreadLocal();
    private static final Object[] NO_ARGS = new Object[0];
    private final Map<BeanContext, ObjectName> mbeanNames = new ConcurrentHashMap<BeanContext, ObjectName>();
    private final Map<BeanContext, MdbActivationContext> activationContexts = new ConcurrentHashMap<BeanContext, MdbActivationContext>();
    private final Object containerID;
    private final SecurityService securityService;
    private final ResourceAdapter resourceAdapter;
    private final Class messageListenerInterface;
    private final Class activationSpecClass;
    private final int instanceLimit;
    private final boolean failOnUnknownActivationSpec;
    private final ConcurrentMap<Object, BeanContext> deployments = new ConcurrentHashMap<Object, BeanContext>();
    private final XAResourceWrapper xaResourceWrapper;
    private final InboundRecovery inboundRecovery;
    private final Properties properties = new Properties();

    public MdbContainer(Object containerID, SecurityService securityService, ResourceAdapter resourceAdapter, Class messageListenerInterface, Class activationSpecClass, int instanceLimit, boolean failOnUnknownActivationSpec) {
        this.containerID = containerID;
        this.securityService = securityService;
        this.resourceAdapter = resourceAdapter;
        this.messageListenerInterface = messageListenerInterface;
        this.activationSpecClass = activationSpecClass;
        this.instanceLimit = instanceLimit;
        this.failOnUnknownActivationSpec = failOnUnknownActivationSpec;
        this.xaResourceWrapper = (XAResourceWrapper)SystemInstance.get().getComponent(XAResourceWrapper.class);
        this.inboundRecovery = (InboundRecovery)SystemInstance.get().getComponent(InboundRecovery.class);
    }

    @Override
    public BeanContext[] getBeanContexts() {
        return this.deployments.values().toArray(new BeanContext[this.deployments.size()]);
    }

    @Override
    public BeanContext getBeanContext(Object deploymentID) {
        return (BeanContext)this.deployments.get(deploymentID);
    }

    @Override
    public ContainerType getContainerType() {
        return ContainerType.MESSAGE_DRIVEN;
    }

    @Override
    public Object getContainerID() {
        return this.containerID;
    }

    @Override
    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    @Override
    public Class getMessageListenerInterface() {
        return this.messageListenerInterface;
    }

    public Class getActivationSpecClass() {
        return this.activationSpecClass;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void deploy(BeanContext beanContext) throws OpenEJBException {
        Object deploymentId = beanContext.getDeploymentID();
        if (!beanContext.getMdbInterface().equals(this.messageListenerInterface)) {
            throw new OpenEJBException("Deployment '" + deploymentId + "' has message listener interface " + beanContext.getMdbInterface().getName() + " but this MDB container only supports " + this.messageListenerInterface);
        }
        ActivationSpec activationSpec = this.createActivationSpec(beanContext);
        if (this.inboundRecovery != null) {
            this.inboundRecovery.recover(this.resourceAdapter, activationSpec, this.containerID.toString());
        }
        Options options = new Options(beanContext.getProperties());
        int instanceLimit = options.get("InstanceLimit", this.instanceLimit);
        MdbInstanceFactory instanceFactory = new MdbInstanceFactory(beanContext, this.securityService, instanceLimit);
        EndpointFactory endpointFactory = new EndpointFactory(activationSpec, this, beanContext, instanceFactory, null, this.xaResourceWrapper, false);
        beanContext.setContainer(this);
        beanContext.setContainerData(endpointFactory);
        this.deployments.put(deploymentId, beanContext);
        MBeanServer server = LocalMBeanServer.get();
        if (StatsInterceptor.isStatsActivated()) {
            StatsInterceptor stats = new StatsInterceptor(beanContext.getBeanClass());
            beanContext.addFirstSystemInterceptor(stats);
            ObjectNameBuilder jmxName = new ObjectNameBuilder("openejb.management");
            jmxName.set("J2EEServer", "openejb");
            jmxName.set("J2EEApplication", null);
            jmxName.set("EJBModule", beanContext.getModuleID());
            jmxName.set("MessageDrivenBean", beanContext.getEjbName());
            jmxName.set("j2eeType", "");
            jmxName.set("name", beanContext.getEjbName());
            try {
                ObjectName objectName = jmxName.set("j2eeType", "Invocations").build();
                if (server.isRegistered(objectName)) {
                    server.unregisterMBean(objectName);
                }
                server.registerMBean(new ManagedMBean(stats), objectName);
                endpointFactory.jmxNames.add(objectName);
            }
            catch (Exception e) {
                logger.error("Unable to register MBean ", e);
            }
        }
        ObjectNameBuilder jmxName = new ObjectNameBuilder("openejb.management");
        jmxName.set("J2EEServer", "openejb");
        jmxName.set("J2EEApplication", null);
        jmxName.set("EJBModule", beanContext.getModuleID());
        jmxName.set("MessageDrivenBean", beanContext.getEjbName());
        jmxName.set("j2eeType", "");
        jmxName.set("name", beanContext.getEjbName());
        try {
            ObjectName objectName = jmxName.set("j2eeType", "Instances").build();
            if (server.isRegistered(objectName)) {
                server.unregisterMBean(objectName);
            }
            server.registerMBean(new ManagedMBean(new InstanceMonitor(instanceFactory)), objectName);
            endpointFactory.jmxNames.add(objectName);
        }
        catch (Exception e) {
            logger.error("Unable to register MBean ", e);
        }
        CURRENT.set(beanContext);
        try {
            MdbActivationContext activationContext = new MdbActivationContext(Thread.currentThread().getContextClassLoader(), beanContext, this.resourceAdapter, endpointFactory, activationSpec);
            this.activationContexts.put(beanContext, activationContext);
            boolean activeOnStartup = true;
            String activeOnStartupSetting = beanContext.getActivationProperties().get("MdbActiveOnStartup");
            if (activeOnStartupSetting == null) {
                activeOnStartupSetting = beanContext.getActivationProperties().get("DeliveryActive");
            }
            if (activeOnStartupSetting != null) {
                activeOnStartup = Boolean.parseBoolean(activeOnStartupSetting);
            }
            if (activeOnStartup) {
                activationContext.start();
            } else {
                logger.info("Not auto-activating endpoint for " + beanContext.getDeploymentID());
            }
            String jmxName2 = beanContext.getActivationProperties().get("MdbJMXControl");
            if (jmxName2 == null) {
                jmxName2 = "true";
            }
            this.addJMxControl(beanContext, jmxName2, activationContext);
        }
        catch (ResourceException e) {
            beanContext.setContainer(null);
            beanContext.setContainerData(null);
            this.deployments.remove(deploymentId);
            throw new OpenEJBException(e);
        }
        finally {
            CURRENT.remove();
        }
    }

    private ActivationSpec createActivationSpec(BeanContext beanContext) throws OpenEJBException {
        try {
            ObjectRecipe objectRecipe = new ObjectRecipe(this.activationSpecClass);
            objectRecipe.allow(Option.IGNORE_MISSING_PROPERTIES);
            objectRecipe.disallow(Option.FIELD_INJECTION);
            Map<String, String> activationProperties = beanContext.getActivationProperties();
            for (Map.Entry<String, String> entry : activationProperties.entrySet()) {
                objectRecipe.setMethodProperty(entry.getKey(), (Object)entry.getValue());
            }
            objectRecipe.setMethodProperty("beanClass", (Object)beanContext.getBeanClass());
            ActivationSpec activationSpec = (ActivationSpec)objectRecipe.create(this.activationSpecClass.getClassLoader());
            TreeSet unusedProperties = new TreeSet(objectRecipe.getUnsetProperties().keySet());
            unusedProperties.remove("destination");
            unusedProperties.remove("destinationType");
            unusedProperties.remove("destinationLookup");
            unusedProperties.remove("connectionFactoryLookup");
            unusedProperties.remove("beanClass");
            unusedProperties.remove("MdbActiveOnStartup");
            unusedProperties.remove("MdbJMXControl");
            unusedProperties.remove("DeliveryActive");
            if (!unusedProperties.isEmpty()) {
                String text = "No setter found for the activation spec properties: " + unusedProperties;
                if (this.failOnUnknownActivationSpec) {
                    throw new IllegalArgumentException(text);
                }
                logger.warning(text);
            }
            try {
                activationSpec.validate();
            }
            catch (UnsupportedOperationException uoe) {
                logger.info("ActivationSpec does not support validate. Implementation of validate is optional");
            }
            try {
                Validator validator = (Validator)beanContext.getJndiContext().lookup("comp/Validator");
                Set generalSet = validator.validate((Object)activationSpec, new Class[0]);
                if (!generalSet.isEmpty()) {
                    throw new ConstraintViolationException("Constraint violation for ActivationSpec " + this.activationSpecClass.getName(), generalSet);
                }
            }
            catch (NamingException e) {
                logger.debug("No Validator bound to JNDI context");
            }
            activationSpec.setResourceAdapter(this.resourceAdapter);
            return activationSpec;
        }
        catch (Exception e) {
            throw new OpenEJBException("Unable to create activation spec", e);
        }
    }

    @Override
    public void start(BeanContext info) throws OpenEJBException {
        EjbTimerService timerService = info.getEjbTimerService();
        if (timerService != null) {
            timerService.start();
        }
    }

    @Override
    public void stop(BeanContext info) throws OpenEJBException {
        info.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeploy(BeanContext beanContext) throws OpenEJBException {
        block12: {
            if (!(beanContext instanceof BeanContext)) {
                return;
            }
            try {
                EndpointFactory endpointFactory = (EndpointFactory)beanContext.getContainerData();
                if (endpointFactory == null) break block12;
                CURRENT.set(beanContext);
                try {
                    MdbActivationContext activationContext;
                    ObjectName jmxBeanToRemove = this.mbeanNames.remove(beanContext);
                    if (jmxBeanToRemove != null) {
                        LocalMBeanServer.unregisterSilently(jmxBeanToRemove);
                        logger.info("Undeployed MDB control for " + beanContext.getDeploymentID());
                    }
                    if ((activationContext = this.activationContexts.remove(beanContext)) != null && activationContext.isStarted()) {
                        this.resourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, endpointFactory.getActivationSpec());
                    }
                }
                finally {
                    CURRENT.remove();
                }
                MBeanServer server = LocalMBeanServer.get();
                for (ObjectName objectName : endpointFactory.jmxNames) {
                    try {
                        server.unregisterMBean(objectName);
                    }
                    catch (Exception e) {
                        logger.error("Unable to unregister MBean " + objectName);
                    }
                }
            }
            finally {
                beanContext.setContainer(null);
                beanContext.setContainerData(null);
                this.deployments.remove(beanContext.getDeploymentID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object deploymentId, InterfaceType type, Class callInterface, Method method, Object[] args, Object primKey) throws OpenEJBException {
        Instance instance;
        BeanContext beanContext = this.getBeanContext(deploymentId);
        EndpointFactory endpointFactory = (EndpointFactory)beanContext.getContainerData();
        MdbInstanceFactory instanceFactory = endpointFactory.getInstanceFactory();
        try {
            instance = (Instance)instanceFactory.createInstance(true);
        }
        catch (UnavailableException e) {
            throw new SystemException("Unable to create instance for invocation", e);
        }
        try {
            this.beforeDelivery(beanContext, instance, method, null);
            Object value = this.invoke((Object)instance, method, type, args);
            this.afterDelivery(instance);
            Object object = value;
            return object;
        }
        finally {
            instanceFactory.freeInstance(instance, true);
        }
    }

    @Override
    public void beforeDelivery(BeanContext deployInfo, Object instance, Method method, XAResource xaResource) throws SystemException {
        ThreadContext callContext = new ThreadContext(deployInfo, null);
        ThreadContext oldContext = ThreadContext.enter(callContext);
        MdbCallContext mdbCallContext = new MdbCallContext();
        callContext.set(MdbCallContext.class, mdbCallContext);
        mdbCallContext.deliveryMethod = method;
        mdbCallContext.oldCallContext = oldContext;
        try {
            mdbCallContext.txPolicy = EjbTransactionUtil.createTransactionPolicy(deployInfo.getTransactionType(method), callContext);
            if (xaResource != null && mdbCallContext.txPolicy.isNewTransaction()) {
                mdbCallContext.txPolicy.enlistResource(xaResource);
            }
        }
        catch (ApplicationException e) {
            ThreadContext.exit(oldContext);
            throw new SystemException("Should never get an Application exception", e);
        }
        catch (SystemException e) {
            ThreadContext.exit(oldContext);
            throw e;
        }
        catch (Exception e) {
            ThreadContext.exit(oldContext);
            throw new SystemException("Unable to enlist xa resource in the transaction", e);
        }
    }

    @Override
    public Object invoke(Object instance, Method method, InterfaceType type, Object ... args) throws SystemException, ApplicationException {
        Object object;
        block11: {
            OpenEJBException openEjbException;
            block12: {
                if (args == null) {
                    args = NO_ARGS;
                }
                ThreadContext callContext = ThreadContext.getThreadContext();
                BeanContext deployInfo = callContext.getBeanContext();
                MdbCallContext mdbCallContext = callContext.get(MdbCallContext.class);
                if (mdbCallContext == null) {
                    throw new IllegalStateException("beforeDelivery was not called");
                }
                if (!mdbCallContext.deliveryMethod.getName().equals(method.getName()) || !Arrays.deepEquals(mdbCallContext.deliveryMethod.getParameterTypes(), method.getParameterTypes())) {
                    throw new IllegalStateException("Delivery method specified in beforeDelivery is not the delivery method called");
                }
                Object returnValue = null;
                openEjbException = null;
                Operation oldOperation = callContext.getCurrentOperation();
                callContext.setCurrentOperation(type == InterfaceType.TIMEOUT ? Operation.TIMEOUT : Operation.BUSINESS);
                try {
                    if (logger.isDebugEnabled()) {
                        logger.info("invoking method " + method.getName() + " on " + deployInfo.getDeploymentID());
                    }
                    Method targetMethod = deployInfo.getMatchingBeanMethod(method);
                    callContext.set(Method.class, targetMethod);
                    object = returnValue = this._invoke(instance, targetMethod, args, deployInfo, type, mdbCallContext);
                    callContext.setCurrentOperation(oldOperation);
                    if (!logger.isDebugEnabled()) break block11;
                    if (openEjbException != null) break block12;
                    logger.debug("finished invoking method " + method.getName() + ". Return value:" + returnValue);
                }
                catch (ApplicationException | SystemException e) {
                    try {
                        openEjbException = e;
                        throw e;
                    }
                    catch (Throwable throwable) {
                        callContext.setCurrentOperation(oldOperation);
                        if (logger.isDebugEnabled()) {
                            if (openEjbException == null) {
                                logger.debug("finished invoking method " + method.getName() + ". Return value:" + returnValue);
                            } else {
                                Throwable exception = openEjbException.getRootCause() != null ? openEjbException.getRootCause() : openEjbException;
                                logger.debug("finished invoking method " + method.getName() + " with exception " + exception);
                            }
                        }
                        throw throwable;
                    }
                }
                break block11;
            }
            Throwable exception = openEjbException.getRootCause() != null ? openEjbException.getRootCause() : openEjbException;
            logger.debug("finished invoking method " + method.getName() + " with exception " + exception);
        }
        return object;
    }

    private Object _invoke(Object instance, Method runMethod, Object[] args, BeanContext beanContext, InterfaceType interfaceType, MdbCallContext mdbCallContext) throws SystemException, ApplicationException {
        try {
            List<InterceptorData> interceptors = beanContext.getMethodInterceptors(runMethod);
            InterceptorStack interceptorStack = new InterceptorStack(((Instance)instance).bean, runMethod, interfaceType == InterfaceType.TIMEOUT ? Operation.TIMEOUT : Operation.BUSINESS, interceptors, ((Instance)instance).interceptors);
            Object returnValue = interceptorStack.invoke(args);
            return returnValue;
        }
        catch (Throwable e) {
            ExceptionType type;
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            if ((type = beanContext.getExceptionType(e)) == ExceptionType.SYSTEM) {
                EjbTransactionUtil.handleSystemException(mdbCallContext.txPolicy, e, ThreadContext.getThreadContext());
            } else {
                EjbTransactionUtil.handleApplicationException(mdbCallContext.txPolicy, e, false);
            }
            throw new AssertionError((Object)"Should not get here");
        }
    }

    @Override
    public void afterDelivery(Object instance) throws SystemException {
        ThreadContext callContext = ThreadContext.getThreadContext();
        MdbCallContext mdbCallContext = callContext.get(MdbCallContext.class);
        try {
            EjbTransactionUtil.afterInvoke(mdbCallContext.txPolicy, callContext);
        }
        catch (ApplicationException e) {
            throw new SystemException("Should never get an Application exception", e);
        }
        finally {
            ThreadContext.exit(mdbCallContext.oldCallContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(BeanContext deployInfo, Object instance) {
        block10: {
            ThreadContext callContext = ThreadContext.getThreadContext();
            boolean contextExitRequired = false;
            if (callContext == null) {
                callContext = new ThreadContext(deployInfo, null);
                ThreadContext.enter(callContext);
                contextExitRequired = true;
            }
            try {
                MdbCallContext mdbCallContext = callContext.get(MdbCallContext.class);
                if (mdbCallContext == null) break block10;
                try {
                    EjbTransactionUtil.afterInvoke(mdbCallContext.txPolicy, callContext);
                }
                catch (Exception e) {
                    logger.error("error while releasing message endpoint", e);
                }
                finally {
                    EndpointFactory endpointFactory = (EndpointFactory)deployInfo.getContainerData();
                    endpointFactory.getInstanceFactory().freeInstance((Instance)instance, false);
                }
            }
            finally {
                if (contextExitRequired) {
                    ThreadContext.exit(callContext);
                }
            }
        }
    }

    private void addJMxControl(BeanContext current, String name, MdbActivationContext activationContext) throws ResourceException {
        ObjectName jmxName;
        if (name == null || "false".equalsIgnoreCase(name)) {
            logger.debug("Not adding JMX control for " + current.getDeploymentID());
            return;
        }
        try {
            jmxName = "true".equalsIgnoreCase(name) ? new ObjectNameBuilder().set("J2EEServer", "openejb").set("J2EEApplication", null).set("EJBModule", current.getModuleID()).set("StatelessSessionBean", current.getEjbName()).set("j2eeType", "control").set("name", current.getEjbName()).build() : new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
        this.mbeanNames.put(current, jmxName);
        LocalMBeanServer.registerSilently(new MdbJmxControl(activationContext), jmxName);
        logger.info("Deployed MDB control for " + current.getDeploymentID() + " on " + jmxName);
    }

    public static BeanContext current() {
        BeanContext beanContext = CURRENT.get();
        if (beanContext == null) {
            CURRENT.remove();
        }
        return beanContext;
    }

    public static class InstanceMonitor {
        private final MdbInstanceFactory instanceFactory;

        public InstanceMonitor(MdbInstanceFactory instanceFactory) {
            this.instanceFactory = instanceFactory;
        }

        @Managed
        public int getInstanceLimit() {
            return this.instanceFactory.getInstanceLimit();
        }

        @Managed
        public int getInstanceCount() {
            return this.instanceFactory.getInstanceCount();
        }
    }

    public static final class MdbJmxControl
    implements DynamicMBean {
        private static final AttributeList ATTRIBUTE_LIST = new AttributeList();
        private static final MBeanInfo INFO = new MBeanInfo("org.apache.openejb.resource.activemq.ActiveMQResourceAdapter.MdbJmxControl", "Allows to control a MDB (start/stop)", new MBeanAttributeInfo[]{new MBeanAttributeInfo("started", "boolean", "started: boolean indicating whether this MDB endpoint has been activated.", true, false, true)}, new MBeanConstructorInfo[0], new MBeanOperationInfo[]{new MBeanOperationInfo("start", "Ensure the listener is active.", new MBeanParameterInfo[0], "void", 1), new MBeanOperationInfo("stop", "Ensure the listener is not active.", new MBeanParameterInfo[0], "void", 1)}, new MBeanNotificationInfo[0]);
        private final MdbActivationContext activationContext;

        private MdbJmxControl(MdbActivationContext activationContext) {
            this.activationContext = activationContext;
        }

        @Override
        public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
            if (actionName.equals("stop")) {
                this.activationContext.stop();
            } else if (actionName.equals("start")) {
                try {
                    this.activationContext.start();
                }
                catch (ResourceException e) {
                    logger.error("Error invoking " + actionName + ": " + e.getMessage());
                    throw new MBeanException(new IllegalStateException(e.getMessage(), e));
                }
            } else {
                throw new MBeanException(new IllegalStateException("unsupported operation: " + actionName));
            }
            return null;
        }

        @Override
        public MBeanInfo getMBeanInfo() {
            return INFO;
        }

        @Override
        public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
            if ("started".equals(attribute)) {
                return this.activationContext.isStarted();
            }
            throw new AttributeNotFoundException();
        }

        @Override
        public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
            throw new AttributeNotFoundException();
        }

        @Override
        public AttributeList getAttributes(String[] attributes) {
            return ATTRIBUTE_LIST;
        }

        @Override
        public AttributeList setAttributes(AttributeList attributes) {
            return ATTRIBUTE_LIST;
        }
    }

    private static class MdbActivationContext {
        private final ClassLoader classLoader;
        private final BeanContext beanContext;
        private final ResourceAdapter resourceAdapter;
        private final EndpointFactory endpointFactory;
        private final ActivationSpec activationSpec;
        private AtomicBoolean started = new AtomicBoolean(false);

        public MdbActivationContext(ClassLoader classLoader, BeanContext beanContext, ResourceAdapter resourceAdapter, EndpointFactory endpointFactory, ActivationSpec activationSpec) {
            this.classLoader = classLoader;
            this.beanContext = beanContext;
            this.resourceAdapter = resourceAdapter;
            this.endpointFactory = endpointFactory;
            this.activationSpec = activationSpec;
        }

        public ResourceAdapter getResourceAdapter() {
            return this.resourceAdapter;
        }

        public EndpointFactory getEndpointFactory() {
            return this.endpointFactory;
        }

        public ActivationSpec getActivationSpec() {
            return this.activationSpec;
        }

        public boolean isStarted() {
            return this.started.get();
        }

        public void start() throws ResourceException {
            if (!this.started.compareAndSet(false, true)) {
                return;
            }
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
                this.resourceAdapter.endpointActivation((MessageEndpointFactory)this.endpointFactory, this.activationSpec);
                logger.info("Activated endpoint for " + this.beanContext.getDeploymentID());
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }

        public void stop() {
            if (!this.started.compareAndSet(true, false)) {
                return;
            }
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
                this.resourceAdapter.endpointDeactivation((MessageEndpointFactory)this.endpointFactory, this.activationSpec);
                logger.info("Deactivated endpoint for " + this.beanContext.getDeploymentID());
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
    }

    private static class MdbCallContext {
        private Method deliveryMethod;
        private TransactionPolicy txPolicy;
        private ThreadContext oldCallContext;

        private MdbCallContext() {
        }
    }
}

