/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.security;

import jakarta.resource.spi.work.SecurityContext;
import jakarta.resource.spi.work.WorkCompletedException;
import jakarta.resource.spi.work.WorkContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.geronimo.connector.work.WorkContextHandler;
import org.apache.openejb.core.security.ConnectorCallbackHandler;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.SecurityService;

public class SecurityContextHandler
implements WorkContextHandler<SecurityContext> {
    private ConnectorCallbackHandler callbackHandler;
    private final String securityRealmName;

    public SecurityContextHandler(String securityRealmName) {
        this.securityRealmName = securityRealmName;
    }

    public void before(SecurityContext securityContext) throws WorkCompletedException {
        if (securityContext != null) {
            this.callbackHandler = new ConnectorCallbackHandler(this.securityRealmName);
            Subject clientSubject = new Subject();
            securityContext.setupSecurityContext((CallbackHandler)this.callbackHandler, clientSubject, null);
        }
    }

    public void after(SecurityContext securityContext) throws WorkCompletedException {
        SecurityService securityService = (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
        Object loginObj = securityService.disassociate();
        if (loginObj != null) {
            try {
                securityService.logout(loginObj);
            }
            catch (LoginException loginException) {
                // empty catch block
            }
        }
    }

    public boolean supports(Class<? extends WorkContext> clazz) {
        return SecurityContext.class.isAssignableFrom(clazz);
    }

    public boolean required() {
        return false;
    }
}

