/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.threads.impl;

import jakarta.enterprise.concurrent.ManageableThread;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ManagedThreadFactoryImpl
implements ManagedThreadFactory {
    private static final AtomicInteger ID = new AtomicInteger();
    private final String prefix;

    public ManagedThreadFactoryImpl() {
        this.prefix = "managed-thread-";
    }

    public ManagedThreadFactoryImpl(String prefix) {
        this.prefix = prefix;
    }

    public Thread newThread(Runnable r) {
        ManagedThread thread = new ManagedThread(r);
        thread.setDaemon(true);
        thread.setName(this.prefix + ID.incrementAndGet());
        thread.setContextClassLoader(ManagedThreadFactoryImpl.class.getClassLoader());
        return thread;
    }

    public static class ManagedThread
    extends Thread
    implements ManageableThread {
        public ManagedThread(Runnable r) {
            super(r);
        }

        public boolean isShutdown() {
            return !this.isAlive();
        }
    }
}

