/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.loader;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import org.apache.openejb.loader.ClassPath;

public abstract class BasicURLClassPath
implements ClassPath {
    private Field ucpField;
    private boolean ucpFieldErrorLogged;

    public static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    protected void addJarToPath(URL jar, URLClassLoader loader) throws Exception {
        Object cp = this.getURLClassPath(loader);
        if (cp == null && CustomizableURLClassLoader.class.isInstance(loader)) {
            ((CustomizableURLClassLoader)CustomizableURLClassLoader.class.cast(loader)).add(jar);
        } else {
            this.getAddURLMethod(loader).invoke(cp, jar);
        }
    }

    private Method getAddURLMethod(final URLClassLoader loader) {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    Object cp = BasicURLClassPath.this.getURLClassPath(loader);
                    Class<?> clazz = cp.getClass();
                    return clazz.getDeclaredMethod("addURL", URL.class);
                }
                catch (Exception e) {
                    System.err.println("Can't access addURL from URLClassPath");
                    return null;
                }
            }
        });
    }

    protected synchronized void addJarsToPath(File dir, URLClassLoader loader) throws Exception {
        if (dir == null || !dir.exists()) {
            return;
        }
        String[] jarNames = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return (name = name.toLowerCase(Locale.ENGLISH)).endsWith(".jar") || name.endsWith(".zip");
            }
        });
        URL[] jars = new URL[jarNames.length];
        boolean isWindows = System.getProperty("os.name", "unknown").toLowerCase(Locale.ENGLISH).startsWith("win");
        for (int j = 0; j < jarNames.length; ++j) {
            String name = isWindows ? jarNames[j].toLowerCase() : jarNames[j];
            try {
                jars[j] = new URL(new File(dir, name).getCanonicalFile().getAbsoluteFile().toURI().toURL().toExternalForm());
                continue;
            }
            catch (IOException e) {
                jars[j] = new URL(new File(dir, name).getAbsoluteFile().toURI().toURL().toExternalForm());
            }
        }
        Object cp = this.getURLClassPath(loader);
        if (cp == null && CustomizableURLClassLoader.class.isInstance(loader)) {
            CustomizableURLClassLoader customizableURLClassLoader = (CustomizableURLClassLoader)CustomizableURLClassLoader.class.cast(loader);
            for (URL jar : jars) {
                customizableURLClassLoader.add(jar);
            }
        } else if (cp == null && loader != null && CustomizableURLClassLoader.class.getName().equals(loader.getClass().getName())) {
            Method add = loader.getClass().getMethod("add", URL.class);
            for (URL jar : jars) {
                add.invoke((Object)loader, jar);
            }
        } else {
            Method addURLMethod = this.getAddURLMethod(loader);
            for (URL jar : jars) {
                addURLMethod.invoke(cp, jar);
            }
        }
    }

    protected Object getURLClassPath(URLClassLoader loader) throws Exception {
        Field ucpField = this.getUcpField();
        if (ucpField == null) {
            return null;
        }
        return ucpField.get(loader);
    }

    private Field getUcpField() throws Exception {
        if (this.ucpField == null) {
            this.ucpField = AccessController.doPrivileged(new PrivilegedAction<Field>(){

                @Override
                public Field run() {
                    try {
                        Field ucp = URLClassLoader.class.getDeclaredField("ucp");
                        ucp.setAccessible(true);
                        return ucp;
                    }
                    catch (Exception e2) {
                        if (!BasicURLClassPath.this.ucpFieldErrorLogged) {
                            System.err.println("Can't get ucp field of URLClassLoader");
                            BasicURLClassPath.this.ucpFieldErrorLogged = true;
                        }
                        return null;
                    }
                }
            });
        }
        return this.ucpField;
    }

    protected static class CustomizableURLClassLoader
    extends URLClassLoader {
        protected CustomizableURLClassLoader(ClassLoader parent) {
            super(new URL[0], parent);
        }

        public void add(URL url) {
            super.addURL(url);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> clazz = this.findLoadedClass(name);
                if (clazz != null) {
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
                if (name != null && !name.startsWith("org.apache.openejb")) {
                    try {
                        return CustomizableURLClassLoader.getSystemClassLoader().loadClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if ((clazz = this.loadInternal(name, resolve)) != null) {
                    return clazz;
                }
                clazz = this.loadFromParent(name, resolve);
                if (clazz != null) {
                    return clazz;
                }
                throw new ClassNotFoundException(name);
            }
        }

        private Class<?> loadFromParent(String name, boolean resolve) {
            ClassLoader parent = this.getParent();
            if (parent == null) {
                parent = CustomizableURLClassLoader.getSystemClassLoader();
            }
            try {
                Class<?> clazz = Class.forName(name, false, parent);
                if (clazz != null) {
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return null;
        }

        private Class<?> loadInternal(String name, boolean resolve) {
            try {
                Class<?> clazz = this.findClass(name);
                if (clazz != null) {
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return null;
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }
}

