/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.context;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import javax.servlet.http.HttpServletRequest;
import org.apache.openejb.server.stream.CountingInputStream;
import org.apache.openejb.server.stream.CountingOutputStream;

public final class RequestInfos {
    private static final ThreadLocal<RequestInfo> REQUEST_INFO = new ThreadLocal();

    private RequestInfos() {
    }

    public static void initRequestInfo(HttpServletRequest request) {
        RequestInfo value = RequestInfos.forceRequestInfo();
        value.ip = request.getRemoteAddr();
        REQUEST_INFO.set(value);
    }

    public static void initRequestInfo(Socket socket) {
        RequestInfo value = RequestInfos.forceRequestInfo();
        SocketAddress remoteSocketAddress = socket.getRemoteSocketAddress();
        if (remoteSocketAddress != null && InetSocketAddress.class.isInstance(remoteSocketAddress)) {
            InetSocketAddress socketAddress = (InetSocketAddress)InetSocketAddress.class.cast(remoteSocketAddress);
            InetAddress address = socketAddress.getAddress();
            value.ip = address != null ? address.getHostAddress() : socketAddress.getHostName();
        }
    }

    private static RequestInfo forceRequestInfo() {
        RequestInfo value = REQUEST_INFO.get();
        if (value == null) {
            value = new RequestInfo();
            REQUEST_INFO.set(value);
        }
        return value;
    }

    public static void clearRequestInfo() {
        REQUEST_INFO.remove();
    }

    public static RequestInfo info() {
        return REQUEST_INFO.get();
    }

    public static class RequestInfo {
        public String ip;
        private InputStream inputStream;
        private OutputStream outputStream;

        public InputStream getInputStream() {
            if (null == this.inputStream) {
                throw new RuntimeException("InputStream has not been set");
            }
            return this.inputStream;
        }

        public OutputStream getOutputStream() {
            if (null == this.outputStream) {
                throw new RuntimeException("OutputStream has not been set");
            }
            return this.outputStream;
        }

        public void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public void setOutputStream(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        public String toString() {
            return "RequestInfo{ip='" + this.ip + '\'' + ", request-size=" + (this.inputStream != null && CountingInputStream.class.isInstance(this.inputStream) ? Integer.valueOf(((CountingInputStream)CountingInputStream.class.cast(this.inputStream)).getCount()) : "unknown") + ", response-size=" + (this.outputStream != null && CountingOutputStream.class.isInstance(this.outputStream) ? Integer.valueOf(((CountingOutputStream)CountingOutputStream.class.cast(this.outputStream)).getCount()) : "unknown") + '}';
        }
    }
}

