/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.http.HttpServlet;
import javax.ws.rs.core.Application;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.WebResource;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.NamingResourcesImpl;
import org.apache.catalina.realm.DataSourceRealm;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.webresources.FileResource;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.ClassListInfo;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.ParamValueInfo;
import org.apache.openejb.assembler.classic.ResourceInfo;
import org.apache.openejb.assembler.classic.ServletInfo;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.config.ServiceUtils;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.httpd.WebBeansFilter;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.URLs;
import org.apache.tomcat.util.bcel.classfile.AnnotationEntry;
import org.apache.tomcat.util.bcel.classfile.ClassFormatException;
import org.apache.tomcat.util.bcel.classfile.ElementValuePair;
import org.apache.tomcat.util.bcel.classfile.JavaClass;
import org.apache.tomcat.util.descriptor.web.ContextResource;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.descriptor.web.JspPropertyGroup;
import org.apache.tomcat.util.descriptor.web.WebXml;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomee.catalina.IgnoredStandardContext;
import org.apache.tomee.catalina.OpenEJBNamingResource;
import org.apache.tomee.catalina.TomcatWebAppBuilder;
import org.apache.tomee.catalina.realm.TomEEDataSourceRealm;
import org.apache.tomee.common.ResourceFactory;
import org.apache.tomee.jasper.TomEEJasperInitializer;
import org.apache.tomee.loader.TomcatHelper;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.web.context.WebConversationFilter;
import org.apache.xbean.finder.IAnnotationFinder;

public class OpenEJBContextConfig
extends ContextConfig {
    private static Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB, OpenEJBContextConfig.class);
    private static final String MYFACES_TOMEEM_CONTAINER_INITIALIZER = "org.apache.tomee.myfaces.TomEEMyFacesContainerInitializer";
    private static final String TOMEE_MYFACES_CONTEXT_LISTENER = "org.apache.tomee.myfaces.TomEEMyFacesContextListener";
    private static final String ADJUST_DATASOURCE_JNDI_NAMES = SystemInstance.get().getProperty("tomee.resources.adjust-web-xml-jndi-name", "true");
    private static final String DEFERRED_SYNTAX = SystemInstance.get().getProperty("tomee.webxml.deferred-urls");
    private static final File BASE = SystemInstance.get().getBase().getDirectory();
    private TomcatWebAppBuilder.StandardContextInfo info;
    private IAnnotationFinder finder;
    private ClassLoader tempLoader;
    private Collection<String> webInfClassesAnnotationsProcessed = new ArrayList<String>(1);

    public OpenEJBContextConfig(TomcatWebAppBuilder.StandardContextInfo standardContextInfo) {
        logger.debug("OpenEJBContextConfig({0})", new Object[]{standardContextInfo.toString()});
        this.info = standardContextInfo;
    }

    public void finder(IAnnotationFinder finder, ClassLoader tmpLoader) {
        this.finder = finder;
        this.tempLoader = tmpLoader;
    }

    public void configureStart() {
        super.configureStart();
        this.adjustDataSourceNameIfNecessary();
        this.addAddedJAXWsServices();
        this.cleanUpRestServlets();
    }

    private void addAddedJAXWsServices() {
        WebAppInfo webAppInfo = this.info.get();
        AppInfo appInfo = this.info.app();
        if (webAppInfo == null || appInfo == null || "false".equalsIgnoreCase(appInfo.properties.getProperty("openejb.jaxws.add-missing-servlets", "true"))) {
            return;
        }
        try {
            OpenEJBContextConfig.class.getClassLoader().loadClass("org.apache.openejb.server.webservices.WsServlet");
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return;
        }
        block2: for (ServletInfo servlet : webAppInfo.servlets) {
            if (!servlet.mappings.iterator().hasNext()) continue;
            for (ParamValueInfo pv : servlet.initParams) {
                if (!"openejb-internal".equals(pv.name) || !"true".equals(pv.value)) continue;
                if (this.context.findChild(servlet.servletName) != null) continue block2;
                Wrapper wrapper = this.context.createWrapper();
                wrapper.setName(servlet.servletName);
                wrapper.setServletClass("org.apache.openejb.server.webservices.WsServlet");
                this.context.addChild((Container)wrapper);
                this.context.addServletMapping((String)servlet.mappings.iterator().next(), wrapper.getName());
                continue block2;
            }
        }
    }

    private void cleanUpRestServlets() {
        WebAppInfo webAppInfo = this.info.get();
        AppInfo appInfo = this.info.app();
        if (webAppInfo == null || appInfo == null || "false".equalsIgnoreCase(appInfo.properties.getProperty("openejb.jaxrs.on", "true"))) {
            return;
        }
        Container[] children = this.context.findChildren();
        HashMap<String, Container> mappedChildren = new HashMap<String, Container>();
        if (children != null) {
            for (Container c : children) {
                if (!(c instanceof StandardWrapper)) continue;
                StandardWrapper wrapper = (StandardWrapper)c;
                String appSpec = wrapper.getInitParameter("javax.ws.rs.Application");
                if (appSpec != null) {
                    mappedChildren.put(appSpec, c);
                    continue;
                }
                String app = wrapper.getInitParameter(Application.class.getName());
                if (app != null) {
                    mappedChildren.put(app, c);
                    continue;
                }
                if (wrapper.getServletClass() != null) continue;
                try {
                    if (!Application.class.isAssignableFrom(this.context.getLoader().getClassLoader().loadClass(wrapper.getServletName()))) continue;
                    this.context.removeChild(c);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (String clazz : webAppInfo.restApplications) {
                Container child = (Container)mappedChildren.get(clazz);
                try {
                    String servletClass;
                    if (child == null || !"org.apache.openejb.server.rest.OpenEJBRestServlet".equals(servletClass = ((StandardWrapper)StandardWrapper.class.cast(child)).getServletClass()) && HttpServlet.class.isAssignableFrom(this.info.loader().loadClass(servletClass))) continue;
                    this.context.removeChild(child);
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    this.context.removeChild(child);
                }
            }
        }
    }

    protected void processContextConfig(Digester digester, URL contextXml) {
        try {
            super.processContextConfig(digester, this.replaceKnownRealmsByTomEEOnes(contextXml));
        }
        catch (MalformedURLException e) {
            super.processContextConfig(digester, contextXml);
        }
    }

    private URL replaceKnownRealmsByTomEEOnes(final URL contextXml) throws MalformedURLException {
        return new URL(contextXml.getProtocol(), contextXml.getHost(), contextXml.getPort(), contextXml.getFile(), new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                final URLConnection c = contextXml.openConnection();
                return new URLConnection(u){

                    @Override
                    public void connect() throws IOException {
                        c.connect();
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        IO.copy((InputStream)c.getInputStream(), (OutputStream)baos);
                        return new ByteArrayInputStream(new String(baos.toByteArray()).replace(DataSourceRealm.class.getName(), TomEEDataSourceRealm.class.getName()).getBytes());
                    }

                    @Override
                    public String toString() {
                        return c.toString();
                    }
                };
            }
        });
    }

    protected void contextConfig(Digester digester) {
        NamingResourcesImpl resources = this.context != null ? this.context.getNamingResources() : null;
        if (resources instanceof OpenEJBNamingResource) {
            ((OpenEJBNamingResource)resources).setTomcatResource(true);
        }
        super.contextConfig(digester);
        if (resources instanceof OpenEJBNamingResource) {
            ((OpenEJBNamingResource)resources).setTomcatResource(false);
        }
    }

    private void adjustDataSourceNameIfNecessary() {
        if (this.context == null || "false".equalsIgnoreCase(ADJUST_DATASOURCE_JNDI_NAMES)) {
            return;
        }
        NamingResourcesImpl resources = this.context.getNamingResources();
        if (resources == null) {
            return;
        }
        ContextResource[] foundResources = resources.findResources();
        String[] ids = null;
        if (foundResources != null) {
            for (ContextResource resource : foundResources) {
                if (!"javax.sql.DataSource".equals(resource.getType()) || ResourceFactory.class.getName().equals(resource.getProperty("factory"))) continue;
                String jndiName = (String)resource.getProperty("mappedName");
                if (jndiName == null) {
                    jndiName = resource.getName();
                }
                if (jndiName == null) continue;
                if (ids == null) {
                    Properties props = new Properties();
                    OpenEjbConfiguration runningConfig = (OpenEjbConfiguration)SystemInstance.get().getComponent(OpenEjbConfiguration.class);
                    ArrayList<String> resourceIds = new ArrayList<String>();
                    if (runningConfig != null) {
                        for (ResourceInfo resourceInfo : runningConfig.facilities.resources) {
                            if (!ConfigurationFactory.isResourceType((String)resourceInfo.service, (List)resourceInfo.types, (String)"javax.sql.DataSource") || !ServiceUtils.implies((Properties)props, (Properties)resourceInfo.properties)) continue;
                            resourceIds.add(resourceInfo.id);
                        }
                    }
                    ids = resourceIds.toArray(new String[resourceIds.size()]);
                }
                String mostMatchingId = null;
                for (void var13_17 : ids) {
                    if (var13_17.equals(jndiName)) {
                        mostMatchingId = jndiName;
                        break;
                    }
                    if (jndiName.endsWith("/" + (String)var13_17) && mostMatchingId == null) {
                        mostMatchingId = var13_17;
                        continue;
                    }
                    if (!var13_17.endsWith("/" + jndiName) || mostMatchingId != null) continue;
                    mostMatchingId = "openejb/Resource/" + (String)var13_17;
                }
                if (mostMatchingId == null) continue;
                resource.setProperty("mappedName", (Object)("java:" + mostMatchingId));
                resource.setProperty("resourceid", (Object)("java:" + mostMatchingId));
                resource.setProperty("factory", (Object)ResourceFactory.class.getName());
            }
        }
    }

    protected WebXml createWebXml() {
        StandardContext standardContext;
        String prefix = "";
        if (this.context instanceof StandardContext && (prefix = (standardContext = (StandardContext)this.context).getEncodedPath()).startsWith("/")) {
            prefix = prefix.substring(1);
        }
        OpenEJBWebXml webXml = new OpenEJBWebXml(prefix);
        if (DEFERRED_SYNTAX != null) {
            for (String s : DEFERRED_SYNTAX.split(",")) {
                if (s.isEmpty()) continue;
                JspPropertyGroup propertyGroup = new JspPropertyGroup();
                propertyGroup.addUrlPattern(s);
                propertyGroup.setDeferredSyntax("true");
                webXml.addJspPropertyGroup(propertyGroup);
            }
        }
        return webXml;
    }

    protected void webConfig() {
        TomcatHelper.configureJarScanner((Context)this.context);
        super.webConfig();
        if (IgnoredStandardContext.class.isInstance(this.context)) {
            return;
        }
        if (WebBeansContext.currentInstance() != null) {
            FilterDef asyncOwbFilter = new FilterDef();
            asyncOwbFilter.setAsyncSupported("true");
            asyncOwbFilter.setDescription("OpenEJB CDI Filter - to propagate @RequestScoped in async tasks");
            asyncOwbFilter.setDisplayName("OpenEJB CDI");
            asyncOwbFilter.setFilterClass(WebBeansFilter.class.getName());
            asyncOwbFilter.setFilterName(WebBeansFilter.class.getName());
            this.context.addFilterDef(asyncOwbFilter);
            FilterMap asyncOwbMapping = new FilterMap();
            asyncOwbMapping.setFilterName(asyncOwbFilter.getFilterName());
            asyncOwbMapping.addURLPattern("/*");
            this.context.addFilterMap(asyncOwbMapping);
        }
        if ("true".equalsIgnoreCase(SystemInstance.get().getProperty("tomee.jsp-development", "false"))) {
            for (Container c : this.context.findChildren()) {
                Wrapper servlet;
                if (!Wrapper.class.isInstance(c) || !"org.apache.jasper.servlet.JspServlet".equals((servlet = (Wrapper)Wrapper.class.cast(c)).getServletClass())) continue;
                servlet.addInitParameter("development", "true");
            }
        }
        ClassLoader classLoader = this.context.getLoader().getClassLoader();
        try {
            classLoader.loadClass("com.sun.faces.context.SessionMap");
            return;
        }
        catch (Throwable ignored) {
            try {
                Class<?> myfacesInitializer = Class.forName(MYFACES_TOMEEM_CONTAINER_INITIALIZER, true, classLoader);
                ServletContainerInitializer instance = (ServletContainerInitializer)myfacesInitializer.newInstance();
                this.context.addServletContainerInitializer(instance, this.getJsfClasses(this.context));
                this.context.addApplicationListener(TOMEE_MYFACES_CONTEXT_LISTENER);
            }
            catch (Exception | NoClassDefFoundError throwable) {
                // empty catch block
            }
            return;
        }
    }

    private Set<Class<?>> getJsfClasses(Context context) {
        WebAppBuilder builder = (WebAppBuilder)SystemInstance.get().getComponent(WebAppBuilder.class);
        ClassLoader cl = context.getLoader().getClassLoader();
        Map scanned = (Map)builder.getJsfClasses().get(cl);
        if (scanned == null || scanned.isEmpty()) {
            return null;
        }
        HashSet classes = new HashSet();
        for (Set entry : scanned.values()) {
            for (String name : entry) {
                try {
                    classes.add(cl.loadClass(name));
                }
                catch (ClassNotFoundException ignored) {
                    logger.warning("class '" + name + "' was found but can't be loaded as a JSF class");
                }
            }
        }
        return classes;
    }

    protected void processServletContainerInitializers() {
        super.processServletContainerInitializers();
        Iterator iterator = this.initializerClassMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ServletContainerInitializer sci = (ServletContainerInitializer)entry.getKey();
            String classname = sci.getClass().getName();
            if (classname.equals("org.apache.myfaces.ee6.MyFacesContainerInitializer") || classname.equals("org.springframework.web.SpringServletContainerInitializer")) {
                for (Map.Entry scanning : this.typeInitializerMap.entrySet()) {
                    Set scis = (Set)scanning.getValue();
                    if (scis == null || !scis.contains(sci)) continue;
                    scis.remove(sci);
                }
                iterator.remove();
                continue;
            }
            if (!"org.apache.jasper.servlet.JasperInitializer".equals(classname)) continue;
            iterator.remove();
        }
        this.initializerClassMap.put(new TomEEJasperInitializer(), new HashSet());
        ClassLoader loader = this.context.getLoader().getClassLoader();
        try {
            Class<?> initializer = Class.forName("org.springframework.web.SpringServletContainerInitializer", true, loader);
            ServletContainerInitializer instance = (ServletContainerInitializer)initializer.newInstance();
            this.typeInitializerMap.put(Class.forName("org.springframework.web.WebApplicationInitializer", true, loader), Collections.singleton(instance));
            this.initializerClassMap.put(instance, new HashSet());
        }
        catch (Exception | NoClassDefFoundError ignored) {
            // empty catch block
        }
        if (this.typeInitializerMap.size() > 0 && this.finder != null) {
            for (Map.Entry entry : this.typeInitializerMap.entrySet()) {
                if (entry.getValue() == null || ((Set)entry.getValue()).isEmpty()) continue;
                Class annotation = (Class)entry.getKey();
                for (ServletContainerInitializer sci : (Set)entry.getValue()) {
                    if (annotation.isAnnotation()) {
                        try {
                            Class reloadedAnnotation = (Class)Class.class.cast(this.tempLoader.loadClass(annotation.getName()));
                            this.addClassesWithRightLoader(loader, sci, this.finder.findAnnotatedClasses(reloadedAnnotation));
                        }
                        catch (Throwable th) {}
                        continue;
                    }
                    try {
                        Class<?> reloadedClass = this.tempLoader.loadClass(annotation.getName());
                        List implementations = annotation.isInterface() ? (List)List.class.cast(this.finder.findImplementations(reloadedClass)) : (List)List.class.cast(this.finder.findSubclasses(reloadedClass));
                        this.addClassesWithRightLoader(loader, sci, implementations);
                    }
                    catch (Throwable th) {}
                }
            }
        }
        this.finder = null;
        this.tempLoader = null;
    }

    protected void processAnnotationsWebResource(WebResource webResource, WebXml fragment, boolean handlesTypesOnly) {
        WebAppInfo webAppInfo = this.info.get();
        if (webAppInfo != null && FileResource.class.isInstance(webResource)) {
            File file = new File(((FileResource)FileResource.class.cast(webResource)).getCanonicalPath());
            for (ClassListInfo info : webAppInfo.webAnnotatedClasses) {
                if (this.webInfClassesAnnotationsProcessed.contains(info.name)) continue;
                try {
                    if (!file.getAbsolutePath().startsWith(URLs.toFile((URL)new URL(info.name)).getAbsolutePath())) continue;
                    this.webInfClassesAnnotationsProcessed.add(info.name);
                    this.internalProcessAnnotationsStream(info.list, fragment, false);
                }
                catch (MalformedURLException e) {
                    logger.warning(e.getMessage(), (Throwable)e);
                }
            }
        } else {
            super.processAnnotationsWebResource(webResource, fragment, handlesTypesOnly);
        }
    }

    protected void processAnnotationsStream(InputStream is, WebXml fragment, boolean handlesTypesOnly) throws ClassFormatException, IOException {
    }

    protected void checkHandlesTypes(JavaClass javaClass) {
    }

    protected synchronized void configureStop() {
        this.webInfClassesAnnotationsProcessed.clear();
        super.configureStop();
    }

    protected void processAnnotationsFile(File file, WebXml fragment, boolean handlesTypesOnly) {
        try {
            if (NewLoaderLogic.skip((URL)file.toURI().toURL())) {
                return;
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        WebAppInfo webAppInfo = this.info.get();
        if (webAppInfo == null) {
            super.processAnnotationsFile(file, fragment, handlesTypesOnly);
            return;
        }
        this.internalProcessAnnotations(file, webAppInfo, fragment);
    }

    protected void processAnnotationsUrl(URL currentUrl, WebXml fragment, boolean handlesTypeOnly) {
        File currentUrlAsFile;
        if (NewLoaderLogic.skip((URL)currentUrl)) {
            return;
        }
        WebAppInfo webAppInfo = this.info.get();
        if (webAppInfo == null) {
            super.processAnnotationsUrl(currentUrl, fragment, handlesTypeOnly);
            return;
        }
        try {
            currentUrlAsFile = URLs.toFile((URL)currentUrl);
        }
        catch (IllegalArgumentException iae) {
            logger.error("Don't know this url: " + currentUrl);
            return;
        }
        this.internalProcessAnnotations(currentUrlAsFile, webAppInfo, fragment);
    }

    private void internalProcessAnnotations(File currentUrlAsFile, WebAppInfo webAppInfo, WebXml fragment) {
        for (ClassListInfo webAnnotated : webAppInfo.webAnnotatedClasses) {
            try {
                if (!this.isIncludedIn(webAnnotated.name, currentUrlAsFile)) continue;
                this.internalProcessAnnotationsStream(webAnnotated.list, fragment, false);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private void addClassesWithRightLoader(ClassLoader loader, ServletContainerInitializer sci, List<Class<?>> implementations) throws ClassNotFoundException {
        Set classes = (Set)this.initializerClassMap.get(sci);
        for (Class<?> c : implementations) {
            classes.add(loader.loadClass(c.getName()));
        }
    }

    private void internalProcessAnnotationsStream(Collection<String> urls, WebXml fragment, boolean handlesTypeOnly) {
        for (String url : urls) {
            InputStream is = null;
            try {
                is = new URL(url).openStream();
                super.processAnnotationsStream(is, fragment, handlesTypeOnly);
            }
            catch (IOException e) {
                try {
                    throw new IllegalArgumentException(e);
                }
                catch (Throwable throwable) {
                    IO.close(is);
                    throw throwable;
                }
            }
            IO.close((Closeable)is);
        }
    }

    protected void processAnnotationWebServlet(String className, AnnotationEntry ae, WebXml fragment) {
        try {
            super.processAnnotationWebServlet(className, ae, fragment);
        }
        catch (IllegalArgumentException iae) {
            String[] urlPatterns = null;
            for (ElementValuePair evp : ae.getElementValuePairs()) {
                String name = evp.getNameString();
                if (!"value".equals(name) && !"urlPatterns".equals(name)) continue;
                urlPatterns = this.processAnnotationsStringArray(evp.getValue());
                break;
            }
            if (urlPatterns != null) {
                for (void var9_11 : urlPatterns) {
                    if (!fragment.getServletMappings().containsKey(var9_11)) continue;
                    logger.warning(iae.getMessage(), (Throwable)iae);
                    return;
                }
            }
            throw iae;
        }
    }

    private boolean isIncludedIn(String filePath, File classAsFile) throws MalformedURLException {
        File file;
        File toFile = URLs.toFile((URL)new URL(filePath));
        try {
            file = toFile.getCanonicalFile();
        }
        catch (IOException e) {
            file = toFile;
        }
        File current = classAsFile;
        while (current != null && current.exists()) {
            if (current.equals(file)) {
                File parent = current.getParentFile();
                return !"classes".equals(current.getName()) || parent == null || !"WEB-INF".equals(parent.getName());
            }
            if (!BASE.equals(current = current.getParentFile())) continue;
            return false;
        }
        return false;
    }

    public class OpenEJBWebXml
    extends WebXml {
        public static final String OPENEJB_WEB_XML_MAJOR_VERSION_PROPERTY = "openejb.web.xml.major";
        private String prefix;
        private boolean cdiConversation = false;

        public OpenEJBWebXml(String prefix) {
            this.prefix = prefix;
        }

        public int getMajorVersion() {
            return SystemInstance.get().getOptions().get(this.prefix + "." + OPENEJB_WEB_XML_MAJOR_VERSION_PROPERTY, SystemInstance.get().getOptions().get(OPENEJB_WEB_XML_MAJOR_VERSION_PROPERTY, super.getMajorVersion()));
        }

        public void addFilterMapping(FilterMap filterMap) {
            if ("CDI Conversation Filter".equals(filterMap.getFilterName()) && !this.cdiConversation) {
                FilterDef conversationFilter = new FilterDef();
                conversationFilter.setAsyncSupported("true");
                conversationFilter.setDescription("CDI Conversation Filter");
                conversationFilter.setDisplayName("CDI Conversation Filter");
                conversationFilter.setFilterName("CDI Conversation Filter");
                conversationFilter.setFilterClass(WebConversationFilter.class.getName());
                this.addFilter(conversationFilter);
                this.cdiConversation = true;
            }
            super.addFilterMapping(filterMap);
        }
    }
}

