/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.security.Principal;
import java.security.cert.X509Certificate;
import org.apache.catalina.Realm;
import org.apache.catalina.Wrapper;
import org.apache.catalina.realm.CombinedRealm;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.SecurityService;
import org.apache.tomee.catalina.OpenEJBSecurityListener;
import org.apache.tomee.catalina.TomcatSecurityService;
import org.ietf.jgss.GSSContext;

public class TomEERealm
extends CombinedRealm {
    public Principal authenticate(String username, String password) {
        return this.logInTomEE(super.authenticate(username, password));
    }

    public Principal authenticate(X509Certificate[] certs) {
        return this.logInTomEE(super.authenticate(certs));
    }

    public Principal authenticate(String username, String clientDigest, String nonce, String nc, String cnonce, String qop, String realmName, String md5a2) {
        return this.logInTomEE(super.authenticate(username, clientDigest, nonce, nc, cnonce, qop, realmName, md5a2));
    }

    public Principal authenticate(GSSContext gssContext, boolean storeCreds) {
        return this.logInTomEE(super.authenticate(gssContext, storeCreds));
    }

    public boolean hasRole(Wrapper wrapper, Principal principal, String rawRole) {
        String realRole;
        String role = rawRole;
        if (wrapper != null && (realRole = wrapper.findSecurityReference(role)) != null) {
            role = realRole;
        }
        if (principal == null || role == null) {
            return false;
        }
        if (principal instanceof GenericPrincipal) {
            return ((GenericPrincipal)principal).hasRole(role);
        }
        for (Realm realm : this.realms) {
            if (!realm.hasRole(wrapper, principal, rawRole)) continue;
            return true;
        }
        return false;
    }

    private Principal logInTomEE(Principal pcp) {
        if (pcp == null) {
            return null;
        }
        TomcatSecurityService ss = (TomcatSecurityService)((Object)SystemInstance.get().getComponent(SecurityService.class));
        if (ss != null && OpenEJBSecurityListener.requests.get() != null) {
            ss.enterWebApp((Realm)this, pcp, OpenEJBSecurityListener.requests.get().getWrapper().getRunAs());
        }
        return pcp;
    }
}

