/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina.cdi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletContext;
import org.apache.catalina.connector.Request;
import org.apache.openejb.AppContext;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.tomee.catalina.OpenEJBSecurityListener;

public class ServletContextHandler
implements InvocationHandler {
    private final ConcurrentMap<ClassLoader, ServletContext> contexts = new ConcurrentHashMap<ClassLoader, ServletContext>();

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Request request = OpenEJBSecurityListener.requests.get();
        if (request != null) {
            return method.invoke((Object)request.getServletContext(), args);
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ServletContext c = (ServletContext)this.contexts.get(contextClassLoader);
        if (c != null) {
            return method.invoke((Object)c, args);
        }
        OpenEJBSecurityListener.requests.remove();
        for (AppContext a : ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getAppContexts()) {
            for (WebContext w : a.getWebContexts()) {
                if (w.getClassLoader() != contextClassLoader) continue;
                return method.invoke((Object)w.getServletContext(), args);
            }
        }
        throw new IllegalStateException("Didnt find a web context for " + contextClassLoader);
    }

    public ConcurrentMap<ClassLoader, ServletContext> getContexts() {
        return this.contexts;
    }
}

