/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.embedded;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.inject.Vetoed;
import jakarta.enterprise.inject.spi.BeanManager;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.openejb.config.DeploymentsResolver;
import org.apache.openejb.loader.JarLocation;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.testing.Application;
import org.apache.openejb.testing.ApplicationComposers;
import org.apache.openejb.testing.ContainerProperties;
import org.apache.openejb.testing.Jars;
import org.apache.openejb.testing.RandomPort;
import org.apache.openejb.testing.WebResource;
import org.apache.openejb.util.Classes;
import org.apache.tomee.embedded.Configuration;
import org.apache.tomee.embedded.Container;
import org.apache.tomee.embedded.component.TomEEEmbeddedArgs;
import org.apache.tomee.embedded.event.TomEEEmbeddedApplicationRunnerInjection;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;
import org.apache.xbean.finder.archive.FileArchive;

@Vetoed
public class TomEEEmbeddedApplicationRunner
implements AutoCloseable {
    private static final ConcurrentMap<Runnable, Runnable> SHUTDOWN_TASKS = new ConcurrentHashMap<Runnable, Runnable>();
    private volatile boolean started = false;
    private volatile Object app;
    private volatile Thread hook;

    public static void run(Object app, String ... args) {
        TomEEEmbeddedApplicationRunner runner = new TomEEEmbeddedApplicationRunner();
        runner.start(app, args);
        try {
            new CountDownLatch(1).await();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            runner.close();
        }
    }

    public AutoCloseable start(Object app, String ... args) {
        Properties overrides;
        this.setApp(app);
        Properties properties = overrides = args == null || args.length == 0 ? null : new Properties();
        if (overrides != null) {
            for (String prop : args) {
                String[] seg = prop.split("=");
                if (seg[0].startsWith("--")) {
                    seg[0] = seg[0].substring("--".length());
                }
                overrides.put(seg[0], seg[1]);
            }
        }
        try {
            this.start(app.getClass(), overrides, args);
            return this;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void setApp(Object app) {
        this.app = app;
    }

    public Object getApp() {
        return this.app;
    }

    public synchronized void start(Class<?> marker, Properties config, String ... args) throws Exception {
        WebResource resources;
        ArrayList<URL> urls;
        Jars jars;
        org.apache.openejb.testing.Classes classes;
        Configurers configurers;
        if (this.started) {
            return;
        }
        this.ensureAppInit(marker);
        this.started = true;
        Class<?> appClass = this.app.getClass();
        AnnotationFinder finder = new AnnotationFinder((Archive)new ClassesArchive((Iterable)Classes.ancestors(appClass)));
        Configuration configuration = new Configuration();
        ContainerProperties props = appClass.getAnnotation(ContainerProperties.class);
        if (props != null) {
            Properties runnerProperties = new Properties();
            for (ContainerProperties.Property property : props.value()) {
                String name = property.name();
                if (name.startsWith("tomee.embedded.application.runner.")) {
                    runnerProperties.setProperty(name.substring("tomee.embedded.application.runner.".length()), property.value());
                    continue;
                }
                configuration.property(name, StrSubstitutor.replaceSystemProperties((Object)property.value()));
            }
            if (!runnerProperties.isEmpty()) {
                configuration.loadFromProperties(runnerProperties);
            }
        }
        configuration.loadFromProperties(System.getProperties());
        List annotatedMethods = finder.findAnnotatedMethods(org.apache.openejb.testing.Configuration.class);
        if (annotatedMethods.size() > 1) {
            throw new IllegalArgumentException("Only one @Configuration is supported: " + annotatedMethods);
        }
        for (Method m : annotatedMethods) {
            Object o = m.invoke(this.app, new Object[0]);
            if (Properties.class.isInstance(o)) {
                Properties properties = (Properties)Properties.class.cast(o);
                if (configuration.getProperties() == null) {
                    configuration.setProperties(new Properties());
                }
                configuration.getProperties().putAll((Map<?, ?>)properties);
                continue;
            }
            throw new IllegalArgumentException("Unsupported " + o + " for @Configuration");
        }
        ArrayList<org.apache.tomee.embedded.LifecycleTask> lifecycleTasks = new ArrayList<org.apache.tomee.embedded.LifecycleTask>();
        final ArrayList<Closeable> postTasks = new ArrayList<Closeable>();
        LifecycleTasks tasks = appClass.getAnnotation(LifecycleTasks.class);
        if (tasks != null) {
            for (Class<? extends org.apache.tomee.embedded.LifecycleTask> type : tasks.value()) {
                org.apache.tomee.embedded.LifecycleTask lifecycleTask = type.newInstance();
                lifecycleTasks.add(lifecycleTask);
                postTasks.add(lifecycleTask.beforeContainerStartup());
            }
        }
        HashMap<String, Field> hashMap = new HashMap<String, Field>();
        for (Class<?> type = appClass; type != null && type != Object.class; type = type.getSuperclass()) {
            for (Field f : type.getDeclaredFields()) {
                String value;
                RandomPort annotation = f.getAnnotation(RandomPort.class);
                String string = value = annotation == null ? null : annotation.value();
                if (value == null || !value.startsWith("http")) continue;
                f.setAccessible(true);
                hashMap.put(value, f);
            }
        }
        if (hashMap.containsKey("http")) {
            configuration.randomHttpPort();
        }
        if ((configurers = appClass.getAnnotation(Configurers.class)) != null) {
            for (Class<? extends Configurer> type : configurers.value()) {
                type.newInstance().configure(configuration);
            }
        }
        String context = (classes = appClass.getAnnotation(org.apache.openejb.testing.Classes.class)) != null ? classes.context() : "";
        context = !context.isEmpty() && context.startsWith("/") ? context.substring(1) : context;
        ClassesArchive archive = null;
        if (classes != null && classes.value().length > 0) {
            archive = new ClassesArchive(classes.value());
        }
        if ((jars = appClass.getAnnotation(Jars.class)) != null) {
            Collection files = ApplicationComposers.findFiles((Jars)jars);
            urls = new ArrayList<URL>(files.size());
            for (File f : files) {
                urls.add(f.toURI().toURL());
            }
        } else {
            urls = null;
        }
        if ((resources = appClass.getAnnotation(WebResource.class)) != null && resources.value().length > 1) {
            throw new IllegalArgumentException("Only one docBase is supported for now using @WebResource");
        }
        String webResource = null;
        if (resources != null && resources.value().length > 0) {
            webResource = resources.value()[0];
        } else {
            File webapp = new File("src/main/webapp");
            if (webapp.isDirectory()) {
                webResource = "src/main/webapp";
            }
        }
        if (config != null) {
            configuration.loadFromProperties(config);
        }
        final Container container = new Container(configuration);
        SystemInstance.get().setComponent(TomEEEmbeddedArgs.class, (Object)new TomEEEmbeddedArgs(args, null));
        SystemInstance.get().setComponent(LifecycleTaskAccessor.class, (Object)new LifecycleTaskAccessor(lifecycleTasks));
        container.deploy(new Container.DeploymentRequest(context, urls == null ? new DeploymentsResolver.ClasspathSearcher().loadUrls(Thread.currentThread().getContextClassLoader()).getUrls() : urls, webResource != null ? new File(webResource) : null, true, null, (Archive)archive));
        block15: for (Map.Entry f : hashMap.entrySet()) {
            switch ((String)f.getKey()) {
                case "http": {
                    TomEEEmbeddedApplicationRunner.setPortField((String)f.getKey(), (Field)f.getValue(), configuration, context, this.app);
                    continue block15;
                }
                case "https": {
                    continue block15;
                }
            }
            throw new IllegalArgumentException("port " + (String)f.getKey() + " not yet supported");
        }
        SystemInstance.get().addObserver(this.app);
        this.composerInject(this.app);
        final AnnotationFinder appFinder = new AnnotationFinder((Archive)new ClassesArchive(new Class[]{appClass}));
        for (Method mtd : appFinder.findAnnotatedMethods(PostConstruct.class)) {
            if (mtd.getParameterTypes().length != 0) continue;
            if (!mtd.isAccessible()) {
                mtd.setAccessible(true);
            }
            mtd.invoke(this.app, new Object[0]);
        }
        this.hook = new Thread(){

            @Override
            public void run() {
                for (Method mtd : appFinder.findAnnotatedMethods(PreDestroy.class)) {
                    if (mtd.getParameterTypes().length != 0) continue;
                    if (!mtd.isAccessible()) {
                        mtd.setAccessible(true);
                    }
                    try {
                        mtd.invoke(TomEEEmbeddedApplicationRunner.this.app, new Object[0]);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalStateException(e.getCause());
                    }
                }
                try {
                    container.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                for (Closeable c : postTasks) {
                    try {
                        c.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                postTasks.clear();
                TomEEEmbeddedApplicationRunner.this.app = null;
                try {
                    SHUTDOWN_TASKS.remove(this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        SHUTDOWN_TASKS.put(this.hook, this.hook);
    }

    private void ensureAppInit(Class<?> marker) {
        Class type;
        if (this.app != null) {
            return;
        }
        String typeStr = System.getProperty("tomee.application-composer.application");
        if (typeStr != null) {
            try {
                type = Thread.currentThread().getContextClassLoader().loadClass(typeStr);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            if (marker == null) {
                throw new IllegalArgumentException("set tomee.application-composer.application system property or add a marker to the rule or runner");
            }
            Iterator descriptors = new AnnotationFinder((Archive)new FileArchive(Thread.currentThread().getContextClassLoader(), JarLocation.jarLocation(marker)), false).findAnnotatedClasses(Application.class).iterator();
            if (!descriptors.hasNext()) {
                throw new IllegalArgumentException("No descriptor class using @Application");
            }
            type = (Class)descriptors.next();
            if (descriptors.hasNext()) {
                throw new IllegalArgumentException("Ambiguous @Application: " + type + ", " + descriptors.next());
            }
        }
        try {
            this.app = type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public synchronized void close() {
        if (this.hook != null) {
            this.hook.run();
            SHUTDOWN_TASKS.remove(this.hook);
            this.hook = null;
            this.app = null;
        }
    }

    private static void setPortField(String key, Field value, Configuration configuration, String ctx, Object instance) {
        int port;
        int n = port = "http".equals(key) ? configuration.getHttpPort() : configuration.getHttpsPort();
        if (value.getType() == URL.class) {
            try {
                value.set(instance, new URL(key + "://localhost:" + port + "/" + ctx));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        } else if (value.getType() == Integer.TYPE) {
            try {
                value.set(instance, port);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            throw new IllegalArgumentException("Unsupported " + key);
        }
    }

    public void composerInject(Object target) throws IllegalAccessException {
        WebBeansContext webBeansContext = null;
        try {
            webBeansContext = WebBeansContext.currentInstance();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (webBeansContext != null) {
            OWBInjector.inject((BeanManager)webBeansContext.getBeanManagerImpl(), (Object)target, null);
        }
        for (Class<?> aClass = target.getClass(); aClass != null && aClass != Object.class; aClass = aClass.getSuperclass()) {
            block3: for (Field f : aClass.getDeclaredFields()) {
                TomEEEmbeddedArgs args;
                RandomPort randomPort = f.getAnnotation(RandomPort.class);
                if (randomPort != null) {
                    for (Field field : this.app.getClass().getDeclaredFields()) {
                        RandomPort appPort = field.getAnnotation(RandomPort.class);
                        if (field.getType() != f.getType() || appPort == null || !appPort.value().equals(randomPort.value())) continue;
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        if (!f.isAccessible()) {
                            f.setAccessible(true);
                        }
                        Object value = field.get(this.app);
                        f.set(target, value);
                        continue block3;
                    }
                    continue;
                }
                if (f.isAnnotationPresent(Application.class)) {
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    f.set(target, this.app);
                    continue;
                }
                if (f.isAnnotationPresent(LifecycleTask.class)) {
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    LifecycleTaskAccessor accessor = (LifecycleTaskAccessor)SystemInstance.get().getComponent(LifecycleTaskAccessor.class);
                    Class<?> type = f.getType();
                    Object taskByType = accessor.getTaskByType(type);
                    f.set(target, taskByType);
                    continue;
                }
                if (!f.isAnnotationPresent(Args.class)) continue;
                if (String[].class != f.getType()) {
                    throw new IllegalArgumentException("@Args can only be used for String[] field, not on " + f.getType());
                }
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                f.set(target, (args = (TomEEEmbeddedArgs)SystemInstance.get().getComponent(TomEEEmbeddedArgs.class)) == null ? new String[]{} : args.getArgs());
            }
        }
        SystemInstance.get().fireEvent((Object)new TomEEEmbeddedApplicationRunnerInjection(target));
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread("TomEEEmbeddedApplicationRunner-shutdown"){

            @Override
            public void run() {
                for (Runnable task : SHUTDOWN_TASKS.keySet()) {
                    try {
                        task.run();
                    }
                    catch (Exception e) {
                        Logger.getLogger(TomEEEmbeddedApplicationRunner.class.getName()).log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                SHUTDOWN_TASKS.clear();
            }
        });
    }

    public static final class LifecycleTaskAccessor {
        private final Collection<org.apache.tomee.embedded.LifecycleTask> tasks;

        private LifecycleTaskAccessor(Collection<org.apache.tomee.embedded.LifecycleTask> lifecycleTasks) {
            this.tasks = lifecycleTasks;
        }

        public Collection<org.apache.tomee.embedded.LifecycleTask> getTasks() {
            return this.tasks;
        }

        public <T> T getTaskByType(Class<T> type) {
            for (org.apache.tomee.embedded.LifecycleTask task : this.tasks) {
                if (type != task.getClass()) continue;
                return (T)task;
            }
            if (Collection.class.isAssignableFrom(type)) {
                return (T)this.tasks;
            }
            return null;
        }
    }

    public static interface Configurer {
        public void configure(Configuration var1);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Configurers {
        public Class<? extends Configurer>[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Args {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface LifecycleTask {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface LifecycleTasks {
        public Class<? extends org.apache.tomee.embedded.LifecycleTask>[] value();
    }
}

