/**
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements. See the NOTICE
 * file distributed with this work for additional information regarding copyright ownership. The ASF licenses this file
 * to You under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 *
 * Classes and utilities for working with the sodium native library.
 *
 * <p>
 * Classes and utilities in this package provide an interface to the native Sodium crypto library
 * (https://www.libsodium.org/), which must be installed on the same system as the JVM. It will be searched for in
 * common library locations, or it can be loaded explicitly using
 * {@link org.apache.tuweni.crypto.sodium.Sodium#searchLibrary(java.nio.file.Path...)} or
 * {@link org.apache.tuweni.crypto.sodium.Sodium#loadLibrary(java.nio.file.Path)}.
 *
 * <p>
 * Classes in this package also depend upon the JNR-FFI library being available on the classpath, along with its
 * dependencies. See https://github.com/jnr/jnr-ffi. JNR-FFI can be included using the gradle dependency
 * 'com.github.jnr:jnr-ffi'.
 */
@ParametersAreNonnullByDefault
package org.apache.tuweni.crypto.sodium;

import javax.annotation.ParametersAreNonnullByDefault;
