/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.crypto.mikuli;

import java.util.Objects;
import org.apache.milagro.amcl.BLS381.BIG;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.mikuli.G2Point;
import org.apache.tuweni.crypto.mikuli.Scalar;

public final class SecretKey {
    private final Scalar scalarValue;

    public static SecretKey fromBytes(byte[] bytes) {
        return SecretKey.fromBytes(Bytes.wrap((byte[])bytes));
    }

    public static SecretKey fromBytes(Bytes bytes) {
        return new SecretKey(new Scalar(BIG.fromBytes((byte[])bytes.toArrayUnsafe())));
    }

    SecretKey(Scalar value) {
        this.scalarValue = value;
    }

    G2Point sign(G2Point message) {
        return message.mul(this.scalarValue);
    }

    public Bytes toBytes() {
        byte[] bytea = new byte[48];
        this.scalarValue.value().toBytes(bytea);
        return Bytes.wrap((byte[])bytea);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretKey secretKey = (SecretKey)o;
        return Objects.equals(this.scalarValue, secretKey.scalarValue);
    }

    public int hashCode() {
        return Objects.hash(this.scalarValue);
    }
}

