/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.DecodingException;
import org.apache.tuweni.devp2p.Endpoint;
import org.apache.tuweni.devp2p.Packet;
import org.apache.tuweni.devp2p.PacketKt;
import org.apache.tuweni.devp2p.PacketType;
import org.apache.tuweni.devp2p.PongPacket;
import org.apache.tuweni.devp2p.SigHash;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPException;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019BA\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016R\u0015\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lorg/apache/tuweni/devp2p/PongPacket;", "Lorg/apache/tuweni/devp2p/Packet;", "nodeId", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "to", "Lorg/apache/tuweni/devp2p/Endpoint;", "pingHash", "expiration", "", "enrSeq", "(Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;Lorg/apache/tuweni/crypto/SECP256K1$Signature;Lorg/apache/tuweni/bytes/Bytes32;Lorg/apache/tuweni/devp2p/Endpoint;Lorg/apache/tuweni/bytes/Bytes32;JLjava/lang/Long;)V", "getEnrSeq", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getPingHash", "()Lorg/apache/tuweni/bytes/Bytes32;", "getTo", "()Lorg/apache/tuweni/devp2p/Endpoint;", "encodeTo", "Ljava/nio/ByteBuffer;", "dst", "Companion", "devp2p"})
public final class PongPacket
extends Packet {
    @NotNull
    private final Endpoint to;
    @NotNull
    private final Bytes32 pingHash;
    @Nullable
    private final Long enrSeq;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ByteBuffer encodeTo(@NotNull ByteBuffer dst) {
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        return this.encodeTo(dst, PacketType.PONG, (Function1<? super RLPWriter, Unit>)((Function1)new Function1<RLPWriter, Unit>(this){
            final /* synthetic */ PongPacket this$0;

            public final void invoke(@NotNull RLPWriter writer) {
                Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                org.apache.tuweni.devp2p.PongPacket$Companion.access$encodeTo(PongPacket.Companion, writer, this.this$0.getTo(), this.this$0.getPingHash(), this.this$0.getExpiration(), this.this$0.getEnrSeq());
            }
            {
                this.this$0 = pongPacket;
                super(1);
            }
        }));
    }

    @NotNull
    public final Endpoint getTo() {
        return this.to;
    }

    @NotNull
    public final Bytes32 getPingHash() {
        return this.pingHash;
    }

    @Nullable
    public final Long getEnrSeq() {
        return this.enrSeq;
    }

    private PongPacket(SECP256K1.PublicKey nodeId, SECP256K1.Signature signature, Bytes32 hash, Endpoint to2, Bytes32 pingHash, long expiration, Long enrSeq) {
        super(nodeId, signature, hash, expiration, null);
        this.to = to2;
        this.pingHash = pingHash;
        this.enrSeq = enrSeq;
    }

    public /* synthetic */ PongPacket(SECP256K1.PublicKey nodeId, SECP256K1.Signature signature, Bytes32 hash, Endpoint to2, Bytes32 pingHash, long expiration, Long enrSeq, DefaultConstructorMarker $constructor_marker) {
        this(nodeId, signature, hash, to2, pingHash, expiration, enrSeq);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J5\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000eJ&\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J7\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lorg/apache/tuweni/devp2p/PongPacket$Companion;", "", "()V", "create", "Lorg/apache/tuweni/devp2p/PongPacket;", "keyPair", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "now", "", "to", "Lorg/apache/tuweni/devp2p/Endpoint;", "pingHash", "Lorg/apache/tuweni/bytes/Bytes32;", "enrSeq", "(Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;JLorg/apache/tuweni/devp2p/Endpoint;Lorg/apache/tuweni/bytes/Bytes32;Ljava/lang/Long;)Lorg/apache/tuweni/devp2p/PongPacket;", "decode", "payload", "Lorg/apache/tuweni/bytes/Bytes;", "hash", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "encodeTo", "", "writer", "Lorg/apache/tuweni/rlp/RLPWriter;", "expiration", "(Lorg/apache/tuweni/rlp/RLPWriter;Lorg/apache/tuweni/devp2p/Endpoint;Lorg/apache/tuweni/bytes/Bytes32;JLjava/lang/Long;)V", "devp2p"})
    public static final class Companion {
        @NotNull
        public final PongPacket create(@NotNull SECP256K1.KeyPair keyPair, long now, @NotNull Endpoint to2, @NotNull Bytes32 pingHash, @Nullable Long enrSeq) {
            Intrinsics.checkParameterIsNotNull((Object)keyPair, (String)"keyPair");
            Intrinsics.checkParameterIsNotNull((Object)to2, (String)"to");
            Intrinsics.checkParameterIsNotNull((Object)pingHash, (String)"pingHash");
            long expiration = Packet.Companion.expirationFor(now);
            SigHash sigHash2 = Packet.Companion.createSignature(PacketType.PONG, keyPair, (Function1<? super RLPWriter, Unit>)((Function1)new Function1<RLPWriter, Unit>(to2, pingHash, expiration, enrSeq){
                final /* synthetic */ Endpoint $to;
                final /* synthetic */ Bytes32 $pingHash;
                final /* synthetic */ long $expiration;
                final /* synthetic */ Long $enrSeq;

                public final void invoke(@NotNull RLPWriter writer) {
                    Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                    org.apache.tuweni.devp2p.PongPacket$Companion.access$encodeTo(PongPacket.Companion, writer, this.$to, this.$pingHash, this.$expiration, this.$enrSeq);
                }
                {
                    this.$to = endpoint;
                    this.$pingHash = bytes32;
                    this.$expiration = l;
                    this.$enrSeq = l2;
                    super(1);
                }
            }));
            SECP256K1.PublicKey publicKey = keyPair.publicKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"keyPair.publicKey()");
            return new PongPacket(publicKey, sigHash2.getSignature(), sigHash2.getHash(), to2, pingHash, expiration, enrSeq, null);
        }

        @NotNull
        public final PongPacket decode(@NotNull Bytes payload, @NotNull Bytes32 hash, @NotNull SECP256K1.PublicKey publicKey, @NotNull SECP256K1.Signature signature) {
            Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
            Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
            Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
            Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
            try {
                Object object = RLP.decodeList((Bytes)payload, (Function)new Function<RLPReader, T>(publicKey, signature, hash){
                    final /* synthetic */ SECP256K1.PublicKey $publicKey;
                    final /* synthetic */ SECP256K1.Signature $signature;
                    final /* synthetic */ Bytes32 $hash;

                    @NotNull
                    public final PongPacket apply(RLPReader reader) {
                        Endpoint to2 = (Endpoint)reader.readList((Function)decode.to.1.INSTANCE);
                        Bytes32 pingHash = Bytes32.wrap((Bytes)reader.readValue());
                        long expiration = reader.readLong();
                        Long seq = null;
                        RLPReader rLPReader = reader;
                        Intrinsics.checkExpressionValueIsNotNull((Object)rLPReader, (String)"reader");
                        seq = !rLPReader.isComplete() ? Long.valueOf(reader.readLong()) : (Long)null;
                        Endpoint endpoint = to2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)endpoint, (String)"to");
                        Bytes32 bytes32 = pingHash;
                        Intrinsics.checkExpressionValueIsNotNull((Object)bytes32, (String)"pingHash");
                        return new PongPacket(this.$publicKey, this.$signature, this.$hash, endpoint, bytes32, PacketKt.access$secToMsec(expiration), seq, null);
                    }
                    {
                        this.$publicKey = publicKey;
                        this.$signature = signature;
                        this.$hash = bytes32;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"RLP.decodeList(payload) \u2026piration), seq)\n        }");
                return (PongPacket)object;
            }
            catch (RLPException e) {
                throw (Throwable)new DecodingException("Invalid pong packet", e);
            }
        }

        private final void encodeTo(RLPWriter writer, Endpoint to2, Bytes32 pingHash, long expiration, Long enrSeq) {
            block0: {
                writer.writeList((Consumer)new Consumer<RLPWriter>(to2){
                    final /* synthetic */ Endpoint $to;

                    public final void accept(RLPWriter w) {
                        RLPWriter rLPWriter = w;
                        Intrinsics.checkExpressionValueIsNotNull((Object)rLPWriter, (String)"w");
                        this.$to.writeTo$devp2p(rLPWriter);
                    }
                    {
                        this.$to = endpoint;
                    }
                });
                writer.writeValue((Bytes)pingHash);
                writer.writeLong(PacketKt.access$msecToSec(expiration));
                Long l = enrSeq;
                if (l == null) break block0;
                Long l2 = l;
                long it = ((Number)l2).longValue();
                boolean bl = false;
                writer.writeLong(it);
            }
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$encodeTo(Companion $this, RLPWriter writer, Endpoint to2, Bytes32 pingHash, long expiration, Long enrSeq) {
            $this.encodeTo(writer, to2, pingHash, expiration, enrSeq);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

