/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.rlp;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPWriter;

final class AccumulatingRLPWriter
implements RLPWriter {
    private static final int COMBINE_THRESHOLD = 32;
    private ArrayDeque<byte[]> values = new ArrayDeque();

    AccumulatingRLPWriter() {
    }

    Deque<byte[]> values() {
        return this.values;
    }

    @Override
    public void writeRLP(Bytes value) {
        Objects.requireNonNull(value);
        this.appendBytes(value.toArrayUnsafe());
    }

    @Override
    public void writeValue(Bytes value) {
        Objects.requireNonNull(value);
        this.writeByteArray(value.toArrayUnsafe());
    }

    @Override
    public void writeByteArray(byte[] value) {
        RLP.encodeByteArray(value, this::appendBytes);
    }

    @Override
    public void writeByte(byte value) {
        RLP.encodeByteArray(new byte[]{value}, this::appendBytes);
    }

    @Override
    public void writeLong(long value) {
        this.appendBytes(RLP.encodeNumber(value));
    }

    @Override
    public void writeList(Consumer<RLPWriter> fn) {
        Objects.requireNonNull(fn);
        AccumulatingRLPWriter listWriter = new AccumulatingRLPWriter();
        fn.accept(listWriter);
        int totalSize = 0;
        for (byte[] value : listWriter.values) {
            try {
                totalSize = Math.addExact(totalSize, value.length);
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException("Combined length of values is too long (> Integer.MAX_VALUE)");
            }
        }
        this.appendBytes(RLP.encodeLength(totalSize, 192));
        this.values.addAll(listWriter.values);
    }

    private void appendBytes(byte[] bytes) {
        byte[] last;
        if (bytes.length < 32 && !this.values.isEmpty() && (last = this.values.getLast()).length <= 32 - bytes.length) {
            byte[] combined = new byte[last.length + bytes.length];
            System.arraycopy(last, 0, combined, 0, last.length);
            System.arraycopy(bytes, 0, combined, last.length, bytes.length);
            this.values.pollLast();
            this.values.add(combined);
            return;
        }
        this.values.add(bytes);
    }
}

