/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.rlp;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.rlp.AccumulatingRLPWriter;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPWriter;

final class ByteBufferRLPWriter
implements RLPWriter {
    private ByteBuffer buffer;

    ByteBufferRLPWriter(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void writeRLP(Bytes value) {
        this.buffer.put(value.toArrayUnsafe());
    }

    @Override
    public void writeValue(Bytes value) {
        RLP.encodeByteArray(value.toArrayUnsafe(), this.buffer::put);
    }

    @Override
    public void writeByteArray(byte[] value) {
        RLP.encodeByteArray(value, this.buffer::put);
    }

    @Override
    public void writeByte(byte value) {
        RLP.encodeByteArray(new byte[]{value}, this.buffer::put);
    }

    @Override
    public void writeLong(long value) {
        this.buffer.put(RLP.encodeNumber(value));
    }

    @Override
    public void writeList(Consumer<RLPWriter> fn) {
        Objects.requireNonNull(fn);
        AccumulatingRLPWriter listWriter = new AccumulatingRLPWriter();
        fn.accept(listWriter);
        this.writeEncodedValuesAsList(listWriter.values());
    }

    private void writeEncodedValuesAsList(Deque<byte[]> values) {
        int totalSize = 0;
        for (byte[] value : values) {
            try {
                totalSize = Math.addExact(totalSize, value.length);
            }
            catch (ArithmeticException e) {
                throw new BufferOverflowException();
            }
        }
        this.buffer.put(RLP.encodeLength(totalSize, 192));
        values.forEach(bytes -> this.buffer.put((byte[])bytes));
    }
}

