/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.rlp;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;

public interface RLPWriter {
    public void writeRLP(Bytes var1);

    public void writeValue(Bytes var1);

    default public void writeByteArray(byte[] value) {
        this.writeValue(Bytes.wrap((byte[])value));
    }

    default public void writeByte(byte value) {
        this.writeValue(Bytes.of((byte[])new byte[]{value}));
    }

    default public void writeInt(int value) {
        this.writeLong(value);
    }

    public void writeLong(long var1);

    default public void writeUInt256(UInt256 value) {
        this.writeValue(value.toMinimalBytes());
    }

    default public void writeBigInteger(BigInteger value) {
        if (value.signum() == 0) {
            this.writeInt(0);
            return;
        }
        byte[] byteArray = value.toByteArray();
        if (byteArray[0] == 0) {
            this.writeValue(Bytes.wrap((byte[])byteArray).slice(1));
        } else {
            this.writeByteArray(byteArray);
        }
    }

    default public void writeString(String str) {
        this.writeByteArray(str.getBytes(StandardCharsets.UTF_8));
    }

    public void writeList(Consumer<RLPWriter> var1);

    default public <T> void writeList(List<T> elements, BiConsumer<RLPWriter, T> elementWriter) {
        this.writeList(writer -> {
            for (Object element : elements) {
                elementWriter.accept((RLPWriter)writer, (Object)element);
            }
        });
    }
}

