/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.toml;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.tuweni.toml.ArrayVisitor;
import org.apache.tuweni.toml.InlineTableVisitor;
import org.apache.tuweni.toml.LocalDateVisitor;
import org.apache.tuweni.toml.LocalTimeVisitor;
import org.apache.tuweni.toml.MutableTomlArray;
import org.apache.tuweni.toml.MutableTomlTable;
import org.apache.tuweni.toml.QuotedStringVisitor;
import org.apache.tuweni.toml.TomlParseError;
import org.apache.tuweni.toml.TomlPosition;
import org.apache.tuweni.toml.ZoneOffsetVisitor;
import org.apache.tuweni.toml.internal.TomlParser;
import org.apache.tuweni.toml.internal.TomlParserBaseVisitor;

final class ValueVisitor
extends TomlParserBaseVisitor<Object> {
    private static final Pattern zeroFloat = Pattern.compile("[+-]?0+(\\.[+-]?0*)?([eE].*)?");

    ValueVisitor() {
    }

    @Override
    public Object visitString(TomlParser.StringContext ctx) {
        return ctx.accept(new QuotedStringVisitor()).toString();
    }

    @Override
    public Object visitDecInt(TomlParser.DecIntContext ctx) {
        return this.toLong(ctx.getText().replaceAll("_", ""), 10, ctx);
    }

    @Override
    public Object visitHexInt(TomlParser.HexIntContext ctx) {
        return this.toLong(ctx.getText().substring(2).replaceAll("_", ""), 16, ctx);
    }

    @Override
    public Object visitOctInt(TomlParser.OctIntContext ctx) {
        return this.toLong(ctx.getText().substring(2).replaceAll("_", ""), 8, ctx);
    }

    @Override
    public Object visitBinInt(TomlParser.BinIntContext ctx) {
        return this.toLong(ctx.getText().substring(2).replaceAll("_", ""), 2, ctx);
    }

    private Long toLong(String s, int radix, ParserRuleContext ctx) {
        try {
            return Long.valueOf(s, radix);
        }
        catch (NumberFormatException e) {
            throw new TomlParseError("Integer is too large", new TomlPosition(ctx));
        }
    }

    @Override
    public Object visitRegularFloat(TomlParser.RegularFloatContext ctx) {
        return this.toDouble(ctx.getText().replaceAll("_", ""), ctx);
    }

    @Override
    public Object visitRegularFloatInf(TomlParser.RegularFloatInfContext ctx) {
        return ctx.getText().startsWith("-") ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
    }

    @Override
    public Object visitRegularFloatNaN(TomlParser.RegularFloatNaNContext ctx) {
        return Double.NaN;
    }

    private Double toDouble(String s, ParserRuleContext ctx) {
        try {
            Double value = Double.valueOf(s);
            if (value == Double.POSITIVE_INFINITY || value == Double.NEGATIVE_INFINITY) {
                throw new TomlParseError("Float is too large", new TomlPosition(ctx));
            }
            if (value == 0.0 && !zeroFloat.matcher(s).matches()) {
                throw new TomlParseError("Float is too small", new TomlPosition(ctx));
            }
            return value;
        }
        catch (NumberFormatException e) {
            throw new TomlParseError("Invalid floating point number: " + e.getMessage(), new TomlPosition(ctx));
        }
    }

    @Override
    public Object visitTrueBool(TomlParser.TrueBoolContext ctx) {
        return Boolean.TRUE;
    }

    @Override
    public Object visitFalseBool(TomlParser.FalseBoolContext ctx) {
        return Boolean.FALSE;
    }

    @Override
    public Object visitOffsetDateTime(TomlParser.OffsetDateTimeContext ctx) {
        LocalDate date = ctx.date().accept(new LocalDateVisitor());
        LocalTime time = ctx.time().accept(new LocalTimeVisitor());
        ZoneOffset offset = ctx.timeOffset().accept(new ZoneOffsetVisitor());
        return OffsetDateTime.of(date, time, offset);
    }

    @Override
    public Object visitLocalDateTime(TomlParser.LocalDateTimeContext ctx) {
        LocalDate date = ctx.date().accept(new LocalDateVisitor());
        LocalTime time = ctx.time().accept(new LocalTimeVisitor());
        return LocalDateTime.of(date, time);
    }

    @Override
    public Object visitLocalDate(TomlParser.LocalDateContext ctx) {
        return ctx.date().accept(new LocalDateVisitor());
    }

    @Override
    public Object visitLocalTime(TomlParser.LocalTimeContext ctx) {
        return ctx.time().accept(new LocalTimeVisitor());
    }

    @Override
    public Object visitArray(TomlParser.ArrayContext ctx) {
        TomlParser.ArrayValuesContext valuesContext = ctx.arrayValues();
        if (valuesContext == null) {
            return MutableTomlArray.EMPTY;
        }
        return valuesContext.accept(new ArrayVisitor());
    }

    @Override
    public Object visitInlineTable(TomlParser.InlineTableContext ctx) {
        TomlParser.InlineTableValuesContext valuesContext = ctx.inlineTableValues();
        if (valuesContext == null) {
            return MutableTomlTable.EMPTY;
        }
        return valuesContext.accept(new InlineTableVisitor());
    }

    protected Object aggregateResult(Object aggregate, Object nextResult) {
        return nextResult;
    }

    protected Object defaultResult() {
        return null;
    }
}

