/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.i18n;

import java.util.Locale;
import javax.servlet.ServletContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.view.context.ViewContext;

public class MultiViewsTool {
    protected static final String DEFAULT_LANGUAGE_KEY = "org.apache.velocity.tools.view.i18n.defaultLanguage";
    protected String defaultLanguage;
    protected VelocityEngine engine;

    public void init(Object obj) {
        if (!(obj instanceof ViewContext)) {
            throw new IllegalArgumentException("Tool can only be initialized with a ViewContext");
        }
        ViewContext context = (ViewContext)obj;
        Context vc = context.getVelocityContext();
        this.engine = context.getVelocityEngine();
        this.defaultLanguage = (String)vc.get(DEFAULT_LANGUAGE_KEY);
        if (this.defaultLanguage == null || this.defaultLanguage.trim().equals("")) {
            ServletContext sc = context.getServletContext();
            this.defaultLanguage = (String)sc.getAttribute(DEFAULT_LANGUAGE_KEY);
            if (this.defaultLanguage == null || this.defaultLanguage.trim().equals("")) {
                this.defaultLanguage = Locale.getDefault().getLanguage();
            }
        }
    }

    public String findLocalizedResource(String name, Locale locale) {
        return this.findLocalizedResource(name, locale.getLanguage());
    }

    public String findLocalizedResource(String name) {
        return this.findLocalizedResource(this.defaultLanguage);
    }

    public String findLocalizedResource(String name, String language) {
        String localizedName = name + '.' + language;
        if (!this.engine.templateExists(localizedName)) {
            String defaultLangSuffix = '.' + this.defaultLanguage;
            if (localizedName.endsWith(defaultLangSuffix)) {
                localizedName = name;
            } else {
                localizedName = name + defaultLangSuffix;
                if (!this.engine.templateExists(localizedName)) {
                    localizedName = name;
                }
            }
        }
        return localizedName;
    }
}

