/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.form;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IAfterFormSubmitter;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.util.string.AppendingStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AjaxFormSubmitBehavior
extends AjaxEventBehavior {
    private static final long serialVersionUID = 1L;
    private Form<?> __form;
    private boolean defaultProcessing = true;

    public AjaxFormSubmitBehavior(String event) {
        this(null, event);
    }

    public AjaxFormSubmitBehavior(Form<?> form, String event) {
        super(event);
        this.__form = form;
        if (form != null) {
            form.setOutputMarkupId(true);
        }
    }

    public final Form<?> getForm() {
        if (this.__form == null) {
            this.__form = this.findForm();
            if (this.__form == null) {
                throw new IllegalStateException("form was not specified in the constructor and cannot be found in the hierarchy of the component this behavior is attached to: Component=" + this.getComponent().toString(false));
            }
        }
        return this.__form;
    }

    protected Form<?> findForm() {
        Component component = this.getComponent();
        if (component instanceof Form) {
            return (Form)component;
        }
        return component.findParent(Form.class);
    }

    @Override
    protected CharSequence getEventHandler() {
        String formId = this.getForm().getMarkupId();
        CharSequence url = this.getCallbackUrl();
        AppendingStringBuffer call = new AppendingStringBuffer((CharSequence)"wicketSubmitFormById('").append(formId).append("', '").append((Object)url).append("', ");
        if (this.getComponent() instanceof IFormSubmittingComponent) {
            call.append("'").append(((IFormSubmittingComponent)((Object)this.getComponent())).getInputName()).append("' ");
        } else {
            call.append("null");
        }
        return this.generateCallbackScript((CharSequence)call) + ";";
    }

    @Override
    protected void onEvent(final AjaxRequestTarget target) {
        this.getForm().getRootForm().onFormSubmitted(new IAfterFormSubmitter(){

            @Override
            public Form<?> getForm() {
                return AjaxFormSubmitBehavior.this.getForm();
            }

            @Override
            public boolean getDefaultFormProcessing() {
                return AjaxFormSubmitBehavior.this.getDefaultProcessing();
            }

            @Override
            public void onSubmit() {
                AjaxFormSubmitBehavior.this.onSubmit(target);
            }

            @Override
            public void onError() {
                AjaxFormSubmitBehavior.this.onError(target);
            }

            @Override
            public void onAfterSubmit() {
                AjaxFormSubmitBehavior.this.onAfterSubmit(target);
            }
        });
    }

    protected void onAfterSubmit(AjaxRequestTarget target) {
    }

    protected void onSubmit(AjaxRequestTarget target) {
    }

    protected void onError(AjaxRequestTarget target) {
    }

    @Override
    protected CharSequence getPreconditionScript() {
        return "return Wicket.$$(this)&&Wicket.$$('" + this.getForm().getMarkupId() + "')";
    }

    public boolean getDefaultProcessing() {
        return this.defaultProcessing;
    }

    public void setDefaultProcessing(boolean defaultProcessing) {
        this.defaultProcessing = defaultProcessing;
    }
}

