/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.AbstractSubmitLink;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IFormSubmitListener;
import org.apache.wicket.markup.html.form.IFormSubmitter;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatelessForm<T>
extends Form<T> {
    private static final long serialVersionUID = 1L;

    public StatelessForm(String id) {
        super(id);
    }

    public StatelessForm(String id, IModel<T> model) {
        super(id, model);
    }

    @Override
    protected boolean getStatelessHint() {
        return true;
    }

    @Override
    protected Form.MethodMismatchResponse onMethodMismatch() {
        this.setResponsePage(this.getPage().getClass(), this.getPage().getPageParameters());
        return Form.MethodMismatchResponse.ABORT;
    }

    @Override
    protected CharSequence getActionUrl() {
        return this.urlFor(IFormSubmitListener.INTERFACE, this.getPage().getPageParameters());
    }

    @Override
    public void process(IFormSubmitter submittingComponent) {
        PageParameters parameters;
        super.process(submittingComponent);
        Page page = this.findPage();
        if (page != null && (parameters = page.getPageParameters()) != null) {
            this.visitFormComponents(new IVisitor<FormComponent<?>, Void>(){

                public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                    parameters.remove(formComponent.getInputName());
                }
            });
            parameters.remove(this.getHiddenFieldId());
            if (submittingComponent instanceof AbstractSubmitLink) {
                AbstractSubmitLink submitLink = (AbstractSubmitLink)submittingComponent;
                parameters.remove(submitLink.getInputName());
            }
        }
    }
}

