/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.image.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.resource.DynamicImageResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.io.Streams;

public abstract class BlobImageResource
extends DynamicImageResource {
    private static final long serialVersionUID = 1L;

    public BlobImageResource(String format) {
        super(format);
    }

    public BlobImageResource() {
    }

    protected byte[] getImageData(IResource.Attributes attributes) {
        try {
            Blob blob = this.getBlob(attributes);
            if (blob == null) {
                blob = this.getBlob();
            }
            if (blob != null) {
                InputStream in = blob.getBinaryStream();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Streams.copy((InputStream)in, (OutputStream)out);
                return out.toByteArray();
            }
            return new byte[0];
        }
        catch (SQLException e) {
            throw new WicketRuntimeException("Error while reading image data", e);
        }
        catch (IOException e) {
            throw new WicketRuntimeException("Error while reading image data", e);
        }
    }

    @Deprecated
    protected abstract Blob getBlob();

    protected Blob getBlob(IResource.Attributes attributes) {
        return null;
    }
}

