/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.repeater;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.wicket.markup.html.navigation.paging.IPageableItems;
import org.apache.wicket.markup.repeater.RefreshingView;
import org.apache.wicket.model.IModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPageableView<T>
extends RefreshingView<T>
implements IPageableItems {
    private static final long serialVersionUID = 1L;
    private int itemsPerPage = Integer.MAX_VALUE;
    private int currentPage;
    private transient int cachedItemCount;

    public AbstractPageableView(String id, IModel<? extends Collection<? extends T>> model) {
        super(id, model);
        this.clearCachedItemCount();
    }

    public AbstractPageableView(String id) {
        super(id);
        this.clearCachedItemCount();
    }

    @Override
    protected Iterator<IModel<T>> getItemModels() {
        int offset = this.getFirstItemOffset();
        int size = this.getViewSize();
        Iterator<IModel<T>> models = this.getItemModels(offset, size);
        models = new CappedIteratorAdapter<T>(models, size);
        return models;
    }

    @Override
    protected void onBeforeRender() {
        this.clearCachedItemCount();
        super.onBeforeRender();
    }

    protected abstract Iterator<IModel<T>> getItemModels(int var1, int var2);

    private void clearCachedItemCount() {
        this.cachedItemCount = -1;
    }

    private void setCachedItemCount(int itemCount) {
        this.cachedItemCount = itemCount;
    }

    private int getCachedItemCount() {
        if (this.cachedItemCount < 0) {
            throw new IllegalStateException("getItemCountCache() called when cache was not set");
        }
        return this.cachedItemCount;
    }

    private boolean isItemCountCached() {
        return this.cachedItemCount >= 0;
    }

    @Override
    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public final void setItemsPerPage(int items) {
        if (items < 1) {
            throw new IllegalArgumentException("Argument [itemsPerPage] cannot be less than 1");
        }
        if (this.itemsPerPage != items && this.isVersioned()) {
            this.addStateChange();
        }
        this.itemsPerPage = items;
        this.setCurrentPage(0);
    }

    protected abstract int internalGetItemCount();

    public final int getRowCount() {
        if (!this.isVisibleInHierarchy()) {
            return 0;
        }
        return this.getItemCount();
    }

    @Override
    public final int getItemCount() {
        if (this.isItemCountCached()) {
            return this.getCachedItemCount();
        }
        int count = this.internalGetItemCount();
        this.setCachedItemCount(count);
        return count;
    }

    @Override
    public final int getCurrentPage() {
        int page = this.currentPage;
        if (page > 0 && page >= this.getPageCount()) {
            this.currentPage = page = Math.max(this.getPageCount() - 1, 0);
            return page;
        }
        return page;
    }

    @Override
    public final void setCurrentPage(int page) {
        if (this.currentPage != page && this.isVersioned()) {
            this.addStateChange();
        }
        this.currentPage = page;
    }

    @Override
    public final int getPageCount() {
        int count;
        int total = this.getRowCount();
        int itemsPerPage = this.getItemsPerPage();
        if (itemsPerPage * (count = total / itemsPerPage) < total) {
            ++count;
        }
        return count;
    }

    public int getFirstItemOffset() {
        return this.getCurrentPage() * this.getItemsPerPage();
    }

    public int getViewSize() {
        return Math.min(this.getItemsPerPage(), this.getRowCount() - this.getFirstItemOffset());
    }

    @Override
    protected void onDetach() {
        this.clearCachedItemCount();
        super.onDetach();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.clearCachedItemCount();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CappedIteratorAdapter<T>
    implements Iterator<IModel<T>> {
        private final int max;
        private int index;
        private final Iterator<IModel<T>> delegate;

        public CappedIteratorAdapter(Iterator<IModel<T>> delegate, int max) {
            this.delegate = delegate;
            this.max = max;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.max && this.delegate.hasNext();
        }

        @Override
        public IModel<T> next() {
            if (this.index >= this.max) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return this.delegate.next();
        }
    }
}

