/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.handler.render;

import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.IPageProvider;
import org.apache.wicket.request.handler.RenderPageRequestHandler;
import org.apache.wicket.settings.IRequestCycleSettings;

public abstract class PageRenderer {
    private final RenderPageRequestHandler renderPageRequestHandler;

    public PageRenderer(RenderPageRequestHandler renderPageRequestHandler) {
        this.renderPageRequestHandler = renderPageRequestHandler;
    }

    protected IPageProvider getPageProvider() {
        return this.renderPageRequestHandler.getPageProvider();
    }

    protected RenderPageRequestHandler.RedirectPolicy getRedirectPolicy() {
        return this.renderPageRequestHandler.getRedirectPolicy();
    }

    protected RenderPageRequestHandler getRenderPageRequestHandler() {
        return this.renderPageRequestHandler;
    }

    protected IRequestablePage getPage() {
        return this.getPageProvider().getPageInstance();
    }

    protected boolean isOnePassRender() {
        return Application.get().getRequestCycleSettings().getRenderStrategy() == IRequestCycleSettings.RenderStrategy.ONE_PASS_RENDER;
    }

    protected boolean isRedirectToRender() {
        return Application.get().getRequestCycleSettings().getRenderStrategy() == IRequestCycleSettings.RenderStrategy.REDIRECT_TO_RENDER;
    }

    protected boolean isRedirectToBuffer() {
        return Application.get().getRequestCycleSettings().getRenderStrategy() == IRequestCycleSettings.RenderStrategy.REDIRECT_TO_BUFFER;
    }

    protected String getSessionId() {
        return Session.exists() ? Session.get().getId() : null;
    }

    protected boolean isSessionTemporary() {
        return Session.exists() ? Session.get().isTemporary() : true;
    }

    protected boolean enableRedirectForStatelessPage() {
        return true;
    }

    public abstract void respond(RequestCycle var1);
}

