/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.handler.resource;

import org.apache.wicket.request.ILoggableRequestHandler;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.handler.logger.ResourceStreamLogData;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceStreamResource;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceStreamRequestHandler
implements IRequestHandler,
ILoggableRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(ResourceStreamRequestHandler.class);
    private String fileName;
    private ContentDisposition contentDisposition;
    private Duration cacheDuration;
    private final IResourceStream resourceStream;
    private ResourceStreamLogData logData;

    public ResourceStreamRequestHandler(IResourceStream resourceStream) {
        this(resourceStream, null);
    }

    public ResourceStreamRequestHandler(IResourceStream resourceStream, String fileName) {
        Args.notNull((Object)resourceStream, (String)"resourceStream");
        this.resourceStream = resourceStream;
        this.fileName = fileName;
    }

    public void detach(IRequestCycle requestCycle) {
        if (this.logData == null) {
            this.logData = this.getResourceStream() == null ? new ResourceStreamLogData(this) : new ResourceStreamLogData(this, this.getResourceStream());
        }
    }

    public ResourceStreamLogData getLogData() {
        return this.logData;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final IResourceStream getResourceStream() {
        return this.resourceStream;
    }

    public void respond(IRequestCycle requestCycle) {
        IResource.Attributes attributes = new IResource.Attributes(requestCycle.getRequest(), requestCycle.getResponse());
        ResourceStreamResource resource = new ResourceStreamResource(this.resourceStream);
        this.configure(resource);
        resource.respond(attributes);
    }

    protected void configure(ResourceStreamResource resource) {
        resource.setFileName(this.fileName);
        if (this.contentDisposition != null) {
            resource.setContentDisposition(this.contentDisposition);
        } else {
            resource.setContentDisposition(Strings.isEmpty((CharSequence)this.fileName) ? ContentDisposition.INLINE : ContentDisposition.ATTACHMENT);
        }
        Duration cacheDuration = this.getCacheDuration();
        if (cacheDuration != null) {
            resource.setCacheDuration(cacheDuration);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contentDisposition == null ? 0 : this.contentDisposition.hashCode());
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = 31 * result + this.resourceStream.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceStreamRequestHandler other = (ResourceStreamRequestHandler)obj;
        if (this.contentDisposition != other.contentDisposition) {
            return false;
        }
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        return this.resourceStream.equals(other.resourceStream);
    }

    public final ResourceStreamRequestHandler setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public String toString() {
        return "[ResourceStreamRequestTarget[resourceStream=" + this.resourceStream + ",fileName=" + this.fileName + ", contentDisposition=" + (Object)((Object)this.contentDisposition) + "]";
    }

    public final ContentDisposition getContentDisposition() {
        return this.contentDisposition;
    }

    public final ResourceStreamRequestHandler setContentDisposition(ContentDisposition contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public Duration getCacheDuration() {
        return this.cacheDuration;
    }

    public ResourceStreamRequestHandler setCacheDuration(Duration cacheDuration) {
        this.cacheDuration = cacheDuration;
        return this;
    }
}

