/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.io.IOException;
import java.io.InputStream;
import org.apache.wicket.Application;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.lang.Checks;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.IResourceStreamWriter;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceStreamResource
extends AbstractResource {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ResourceStreamResource.class);
    private IResourceStream stream;
    private String fileName;
    private ContentDisposition contentDisposition = ContentDisposition.INLINE;
    private String textEncoding;
    private Duration cacheDuration;

    public ResourceStreamResource(IResourceStream stream) {
        this.stream = stream;
    }

    public ResourceStreamResource setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public ResourceStreamResource setContentDisposition(ContentDisposition contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public ResourceStreamResource setTextEncoding(String textEncoding) {
        this.textEncoding = textEncoding;
        return this;
    }

    public Duration getCacheDuration() {
        return this.cacheDuration;
    }

    public ResourceStreamResource setCacheDuration(Duration cacheDuration) {
        this.cacheDuration = cacheDuration;
        return this;
    }

    protected IResourceStream getResourceStream() {
        return this.stream;
    }

    private IResourceStream internalGetResourceStream() {
        IResourceStream resourceStream = this.getResourceStream();
        Checks.notNull((Object)resourceStream, (String)"%s#getResourceStream() should not return null!", (Object[])new Object[]{this.getClass().getName()});
        return resourceStream;
    }

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        final IResourceStream resourceStream = this.internalGetResourceStream();
        AbstractResource.ResourceResponse data = new AbstractResource.ResourceResponse();
        Time lastModifiedTime = resourceStream.lastModifiedTime();
        if (lastModifiedTime != null) {
            data.setLastModified(lastModifiedTime);
        }
        if (this.cacheDuration != null) {
            data.setCacheDuration(this.cacheDuration);
        }
        if (data.dataNeedsToBeWritten(attributes)) {
            InputStream inputStream = null;
            if (!(resourceStream instanceof IResourceStreamWriter)) {
                try {
                    inputStream = resourceStream.getInputStream();
                }
                catch (ResourceStreamNotFoundException e) {
                    data.setError(404);
                    this.close(resourceStream);
                }
            }
            data.setContentDisposition(this.contentDisposition);
            Bytes length = resourceStream.length();
            if (length != null) {
                data.setContentLength(length.bytes());
            }
            data.setFileName(this.fileName);
            String contentType = resourceStream.getContentType();
            if (contentType == null && this.fileName != null && Application.exists()) {
                contentType = Application.get().getMimeType(this.fileName);
            }
            data.setContentType(contentType);
            data.setTextEncoding(this.textEncoding);
            if (resourceStream instanceof IResourceStreamWriter) {
                data.setWriteCallback(new AbstractResource.WriteCallback(){

                    public void writeData(IResource.Attributes attributes) {
                        ((IResourceStreamWriter)resourceStream).write(attributes.getResponse());
                        ResourceStreamResource.this.close(resourceStream);
                    }
                });
            } else {
                final InputStream s = inputStream;
                data.setWriteCallback(new AbstractResource.WriteCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void writeData(IResource.Attributes attributes) {
                        try {
                            this.writeStream(attributes, s);
                        }
                        finally {
                            ResourceStreamResource.this.close(resourceStream);
                        }
                    }
                });
            }
        }
        return data;
    }

    private void close(IResourceStream stream) {
        try {
            stream.close();
        }
        catch (IOException e) {
            logger.error("Couldn't close ResourceStream", (Throwable)e);
        }
    }
}

