/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource.caching;

import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.caching.IResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.IStaticCacheableResource;
import org.apache.wicket.request.resource.caching.ResourceUrl;
import org.apache.wicket.request.resource.caching.version.IResourceVersion;
import org.apache.wicket.util.lang.Args;

public class FilenameWithVersionResourceCachingStrategy
implements IResourceCachingStrategy {
    private static final String DEFAULT_VERSION_PREFIX = "-ver-";
    private final String versionPrefix;
    private final IResourceVersion resourceVersion;

    public FilenameWithVersionResourceCachingStrategy(IResourceVersion resourceVersion) {
        this(DEFAULT_VERSION_PREFIX, resourceVersion);
    }

    public FilenameWithVersionResourceCachingStrategy(String versionPrefix, IResourceVersion resourceVersion) {
        this.resourceVersion = (IResourceVersion)Args.notNull((Object)resourceVersion, (String)"resourceVersion");
        this.versionPrefix = (String)Args.notEmpty((CharSequence)versionPrefix, (String)"versionPrefix");
    }

    public final String getVersionPrefix() {
        return this.versionPrefix;
    }

    public void decorateUrl(ResourceUrl url, IStaticCacheableResource resource) {
        String version = this.resourceVersion.getVersion(resource);
        if (version == null) {
            return;
        }
        String filename = url.getFileName();
        int extensionAt = filename.lastIndexOf(46);
        StringBuilder versionedFilename = new StringBuilder();
        if (extensionAt == -1) {
            versionedFilename.append(filename);
        } else {
            versionedFilename.append(filename.substring(0, extensionAt));
        }
        versionedFilename.append(this.versionPrefix);
        versionedFilename.append(version);
        if (extensionAt != -1) {
            versionedFilename.append(filename.substring(extensionAt));
        }
        url.setFileName(versionedFilename.toString());
    }

    public void undecorateUrl(ResourceUrl url) {
        String filename = url.getFileName();
        int pos = filename.lastIndexOf(46);
        String fullname = pos == -1 ? filename : filename.substring(0, pos);
        String extension = pos == -1 ? null : filename.substring(pos);
        pos = fullname.lastIndexOf(this.versionPrefix);
        if (pos != -1) {
            String basename = fullname.substring(0, pos);
            url.setFileName(extension == null ? basename : basename + extension);
        }
    }

    public void decorateResponse(AbstractResource.ResourceResponse response, IStaticCacheableResource resource) {
        response.setCacheDurationToMaximum();
        response.setCacheScope(WebResponse.CacheScope.PUBLIC);
    }
}

