/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.BigDecimalConverter;
import org.apache.wicket.util.convert.converter.BooleanConverter;
import org.apache.wicket.util.convert.converter.ByteConverter;
import org.apache.wicket.util.convert.converter.CalendarConverter;
import org.apache.wicket.util.convert.converter.CharacterConverter;
import org.apache.wicket.util.convert.converter.DateConverter;
import org.apache.wicket.util.convert.converter.DoubleConverter;
import org.apache.wicket.util.convert.converter.FloatConverter;
import org.apache.wicket.util.convert.converter.IntegerConverter;
import org.apache.wicket.util.convert.converter.LongConverter;
import org.apache.wicket.util.convert.converter.ShortConverter;
import org.apache.wicket.util.convert.converter.SqlDateConverter;
import org.apache.wicket.util.convert.converter.SqlTimeConverter;
import org.apache.wicket.util.convert.converter.SqlTimestampConverter;
import org.apache.wicket.util.lang.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterLocator
implements IConverterLocator {
    private static final long serialVersionUID = 1L;
    private final Map<String, IConverter<?>> classToConverter = new HashMap();

    public ConverterLocator() {
        this.set(Boolean.TYPE, BooleanConverter.INSTANCE);
        this.set(Boolean.class, BooleanConverter.INSTANCE);
        this.set(Byte.TYPE, ByteConverter.INSTANCE);
        this.set(Byte.class, ByteConverter.INSTANCE);
        this.set(Character.TYPE, CharacterConverter.INSTANCE);
        this.set(Character.class, CharacterConverter.INSTANCE);
        this.set(Double.TYPE, DoubleConverter.INSTANCE);
        this.set(Double.class, DoubleConverter.INSTANCE);
        this.set(Float.TYPE, FloatConverter.INSTANCE);
        this.set(Float.class, FloatConverter.INSTANCE);
        this.set(Integer.TYPE, IntegerConverter.INSTANCE);
        this.set(Integer.class, IntegerConverter.INSTANCE);
        this.set(Long.TYPE, LongConverter.INSTANCE);
        this.set(Long.class, LongConverter.INSTANCE);
        this.set(Short.TYPE, ShortConverter.INSTANCE);
        this.set(Short.class, ShortConverter.INSTANCE);
        this.set(BigDecimal.class, (IConverter<?>)new BigDecimalConverter());
        this.set(java.util.Date.class, (IConverter<?>)new DateConverter());
        this.set(Date.class, (IConverter<?>)new SqlDateConverter());
        this.set(Time.class, (IConverter<?>)new SqlTimeConverter());
        this.set(Timestamp.class, (IConverter<?>)new SqlTimestampConverter());
        this.set(Calendar.class, (IConverter<?>)new CalendarConverter());
    }

    public final <C> IConverter<C> get(Class<C> c) {
        return this.classToConverter.get(c.getName());
    }

    @Override
    public final <C> IConverter<C> getConverter(Class<C> type) {
        if (type == null) {
            DefaultConverter converter = new DefaultConverter(String.class);
            return converter;
        }
        IConverter<C> converter = this.get(type);
        if (converter == null) {
            return new DefaultConverter(type);
        }
        return converter;
    }

    public final IConverter<?> remove(Class<?> c) {
        return this.classToConverter.remove(c.getName());
    }

    public final IConverter<?> set(Class<?> c, IConverter<?> converter) {
        if (converter == null) {
            throw new IllegalArgumentException("CoverterLocator cannot be null");
        }
        if (c == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        return this.classToConverter.put(c.getName(), converter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultConverter<C>
    implements IConverter<C> {
        private static final long serialVersionUID = 1L;
        private final transient WeakReference<Class<C>> type;

        private DefaultConverter(Class<C> type) {
            this.type = new WeakReference<Class<C>>(type);
        }

        public C convertToObject(String value, Locale locale) {
            if (value == null) {
                return null;
            }
            Class theType = (Class)this.type.get();
            if ("".equals(value)) {
                if (String.class.equals((Object)theType)) {
                    return (C)theType.cast("");
                }
                return null;
            }
            try {
                Object converted = Objects.convertValue((Object)value, (Class)theType);
                if (converted != null) {
                    return (C)converted;
                }
                throw new ConversionException("Could not convert value: " + value + " to type: " + theType.getName() + ". Could not find compatible converter.").setSourceValue((Object)value);
            }
            catch (Exception e) {
                throw new ConversionException(e.getMessage(), (Throwable)e).setSourceValue((Object)value);
            }
        }

        public String convertToString(C value, Locale locale) {
            if (value == null || "".equals(value)) {
                return "";
            }
            try {
                return (String)Objects.convertValue(value, String.class);
            }
            catch (RuntimeException e) {
                throw new ConversionException("Could not convert object of type: " + value.getClass() + " to string. Possible its #toString() returned null. " + "Either install a custom converter (see IConverterLocator) or " + "override #toString() to return a non-null value.", (Throwable)e).setSourceValue(value).setConverter((IConverter)this);
            }
        }
    }
}

