/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.IRedirectListener;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.authorization.UnauthorizedActionException;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.MarkupType;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.model.IModel;
import org.apache.wicket.page.IPageManager;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.settings.IDebugSettings;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.lang.WicketObjects;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Page
extends MarkupContainer
implements IRedirectListener,
IRequestablePage {
    private static final int FLAG_IS_DIRTY = 1024;
    private static final int FLAG_PREVENT_DIRTY = 2048;
    private static final int FLAG_STATELESS_HINT = 65536;
    private static final int FLAG_WAS_CREATED_BOOKMARKABLE = 524288;
    private static final Logger log = LoggerFactory.getLogger(Page.class);
    private static final long serialVersionUID = 1L;
    private int autoIndex;
    private int numericId;
    private transient Set<Component> renderedComponents;
    private transient Boolean stateless = null;
    private final PageParameters pageParameters;
    private int renderCount = 0;

    protected Page() {
        this((PageParameters)null, (IModel<?>)null);
    }

    protected Page(IModel<?> model) {
        this((PageParameters)null, model);
    }

    protected Page(PageParameters parameters) {
        this(parameters, null);
    }

    private Page(PageParameters parameters, IModel<?> model) {
        super(null, model);
        this.pageParameters = parameters == null ? new PageParameters() : parameters;
        this.init();
    }

    @Override
    public PageParameters getPageParameters() {
        return this.pageParameters;
    }

    public final void componentRendered(Component component) {
        if (this.getApplication().getDebugSettings().getComponentUseCheck()) {
            if (this.renderedComponents == null) {
                this.renderedComponents = new HashSet<Component>();
            }
            if (!this.renderedComponents.add(component)) {
                throw new MarkupException("The component " + component + " was rendered already. You can render it only once during a render phase. Class relative path: " + component.getClassRelativePath());
            }
            if (log.isDebugEnabled()) {
                log.debug("Rendered " + component);
            }
        }
    }

    @Override
    public void detachModels() {
        super.detachModels();
    }

    @Override
    public void internalPrepareForRender(boolean setRenderingFlag) {
        if (!this.isInitialized()) {
            this.internalInitialize();
        }
        super.internalPrepareForRender(setRenderingFlag);
    }

    public final void dirty() {
        this.dirty(false);
    }

    @Override
    public boolean setFreezePageId(boolean freeze) {
        boolean frozen = this.getFlag(2048);
        this.setFlag(2048, freeze);
        return frozen;
    }

    public void dirty(boolean isInitialization) {
        this.checkHierarchyChange(this);
        if (this.getFlag(2048)) {
            return;
        }
        IPageManager pageManager = this.getSession().getPageManager();
        if (!this.getFlag(1024) && (this.isVersioned() && pageManager.supportsVersioning() || isInitialization)) {
            this.setFlag(1024, true);
            this.setNextAvailableId();
            pageManager.touchPage(this);
        }
    }

    public final void endComponentRender(Component component) {
        if (component instanceof MarkupContainer) {
            this.checkRendering((MarkupContainer)component);
        } else {
            this.renderedComponents = null;
        }
    }

    public final int getAutoIndex() {
        return this.autoIndex++;
    }

    @Override
    public final String getId() {
        return Integer.toString(this.numericId);
    }

    public final Class<? extends Page> getPageClass() {
        return this.getClass();
    }

    @Override
    public final long getSizeInBytes() {
        return WicketObjects.sizeof((Serializable)((Object)this));
    }

    @Override
    public final boolean getStatelessHint() {
        return this.getFlag(65536);
    }

    public final String hierarchyAsString() {
        final StringBuilder buffer = new StringBuilder();
        buffer.append("Page ").append(this.getId());
        this.visitChildren(new IVisitor<Component, Void>(){

            public void component(Component component, IVisit<Void> visit) {
                int levels = 0;
                for (Component current = component; current != null; current = current.getParent()) {
                    ++levels;
                }
                buffer.append(StringValue.repeat((int)levels, (String)"\t")).append(component.getPageRelativePath()).append(":").append(Classes.simpleName(component.getClass()));
            }
        });
        return buffer.toString();
    }

    @Override
    public boolean isBookmarkable() {
        return this.getApplication().getPageFactory().isBookmarkable(this.getClass());
    }

    public boolean isErrorPage() {
        return false;
    }

    private boolean peekPageStateless() {
        Boolean old = this.stateless;
        Boolean res = this.isPageStateless();
        this.stateless = old;
        return res;
    }

    @Override
    public final boolean isPageStateless() {
        if (!this.isBookmarkable()) {
            this.stateless = Boolean.FALSE;
            if (this.getStatelessHint()) {
                log.warn("Page '" + this + "' is not stateless because it is not bookmarkable, " + "but the stateless hint is set to true!");
            }
        }
        if (!this.getStatelessHint()) {
            return false;
        }
        if (this.stateless == null && !this.isStateless()) {
            this.stateless = Boolean.FALSE;
        }
        if (this.stateless == null) {
            Component statefulComponent = this.visitChildren(Component.class, new IVisitor<Component, Component>(){

                public void component(Component component, IVisit<Component> visit) {
                    if (!component.isStateless()) {
                        visit.stop((Object)component);
                    }
                }
            });
            this.stateless = statefulComponent == null;
            if (log.isDebugEnabled() && !this.stateless.booleanValue() && this.getStatelessHint()) {
                log.debug("Page '{}' is not stateless because of component with path '{}'.", (Object)this, (Object)statefulComponent.getPageRelativePath());
            }
        }
        return this.stateless;
    }

    @Override
    public final void onRedirect() {
    }

    public final void setNumericId(int id) {
        this.numericId = id;
    }

    public final void setStatelessHint(boolean value) {
        if (value && !this.isBookmarkable()) {
            throw new WicketRuntimeException("Can't set stateless hint to true on a page when the page is not bookmarkable, page: " + this);
        }
        this.setFlag(65536, value);
    }

    public final void startComponentRender(Component component) {
        this.renderedComponents = null;
    }

    @Override
    public String toString() {
        return "[Page class = " + this.getClass().getName() + ", id = " + this.getId() + ", render count = " + this.getRenderCount() + "]";
    }

    private void checkRendering(MarkupContainer renderedContainer) {
        IDebugSettings debugSettings = this.getApplication().getDebugSettings();
        if (debugSettings.getComponentUseCheck()) {
            final ArrayList unrenderedComponents = new ArrayList();
            final StringBuilder buffer = new StringBuilder();
            renderedContainer.visitChildren(new IVisitor<Component, Void>(){

                public void component(Component component, IVisit<Void> visit) {
                    if (Page.this.renderedComponents == null || !Page.this.renderedComponents.contains(component)) {
                        if (!component.isAuto() && component.isVisibleInHierarchy()) {
                            unrenderedComponents.add(component);
                            buffer.append(Integer.toString(unrenderedComponents.size())).append(". ").append(component).append('\n');
                            String metadata = component.getMetaData(Component.CONSTRUCTED_AT_KEY);
                            if (metadata != null) {
                                buffer.append(metadata);
                            }
                            if ((metadata = component.getMetaData(Component.ADDED_AT_KEY)) != null) {
                                buffer.append(metadata);
                            }
                        } else {
                            visit.dontGoDeeper();
                        }
                    }
                }
            });
            if (unrenderedComponents.size() > 0) {
                this.renderedComponents = null;
                ArrayList transparentContainerChildren = Generics.newArrayList();
                Iterator iterator = unrenderedComponents.iterator();
                block0: while (iterator.hasNext()) {
                    Component component = (Component)iterator.next();
                    for (Component transparentContainerChild : transparentContainerChildren) {
                        for (MarkupContainer parent = component.getParent(); parent != null; parent = parent.getParent()) {
                            if (parent != transparentContainerChild) continue;
                            iterator.remove();
                            continue block0;
                        }
                    }
                    if (!this.hasInvisibleTransparentChild(component.getParent(), component)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Component {} wasn't rendered but might have a transparent parent.", (Object)component);
                    }
                    transparentContainerChildren.add(component);
                    iterator.remove();
                }
                if (unrenderedComponents.size() > 0) {
                    throw new WicketRuntimeException("The component(s) below failed to render. Possible reasons could be that: 1) you have added a component in code but forgot to reference it in the markup (thus the component will never be rendered), 2) if your components were added in a parent container then make sure the markup for the child container includes them in <wicket:extend>.\n\n" + buffer.toString());
                }
            }
        }
        this.renderedComponents = null;
    }

    private boolean hasInvisibleTransparentChild(MarkupContainer root, Component self) {
        for (Component sibling : root) {
            if (sibling == self || !(sibling instanceof IComponentResolver) || !(sibling instanceof MarkupContainer)) continue;
            if (!sibling.isVisible()) {
                return true;
            }
            boolean rtn = this.hasInvisibleTransparentChild((MarkupContainer)sibling, self);
            if (!rtn) continue;
            return true;
        }
        return false;
    }

    private void init() {
        if (!this.isBookmarkable()) {
            this.setStatelessHint(false);
        }
        this.setVersioned(this.getApplication().getPageSettings().getVersionPagesByDefault());
        this.dirty(true);
        this.stateless = null;
    }

    private void setNextAvailableId() {
        this.setNumericId(this.getSession().nextPageId());
    }

    protected void componentChanged(Component component, MarkupContainer parent) {
        if (!component.isAuto()) {
            this.dirty();
        }
    }

    @Override
    protected final void internalOnModelChanged() {
        this.visitChildren(new IVisitor<Component, Void>(){

            public void component(Component component, IVisit<Void> visit) {
                if (component.sameInnermostModel(Page.this)) {
                    component.modelChanged();
                }
            }
        });
    }

    @Override
    void internalOnAfterConfigure() {
        super.internalOnAfterConfigure();
        if (!this.isActionAuthorized(RENDER)) {
            if (log.isDebugEnabled()) {
                log.debug("Page not allowed to render: " + this);
            }
            throw new UnauthorizedActionException(this, Component.RENDER);
        }
    }

    @Override
    protected void onBeforeRender() {
        this.renderedComponents = null;
        if (Boolean.TRUE.equals(this.stateless)) {
            this.stateless = null;
        }
        super.onBeforeRender();
        if (this.getSession().isTemporary() && !this.peekPageStateless()) {
            this.getSession().bind();
        }
    }

    @Override
    protected void onAfterRender() {
        super.onAfterRender();
        this.checkRendering(this);
        if (this.getApplication().getDebugSettings().getComponentUseCheck()) {
            this.visitChildren(new IVisitor<Component, Void>(){

                public void component(Component component, IVisit<Void> visit) {
                    component.setMetaData(Component.CONSTRUCTED_AT_KEY, null);
                    component.setMetaData(Component.ADDED_AT_KEY, null);
                }
            });
        }
        if (!this.isPageStateless()) {
            this.getSession().getSessionStore().getSessionId(RequestCycle.get().getRequest(), true);
            this.getSession().getPageManager().touchPage(this);
        }
        if (this.getApplication().getDebugSettings().isOutputMarkupContainerClassName()) {
            Class<?> klass = this.getClass();
            while (klass.isAnonymousClass()) {
                klass = klass.getSuperclass();
            }
            this.getResponse().write((CharSequence)"<!-- Page Class ");
            this.getResponse().write((CharSequence)klass.getName());
            this.getResponse().write((CharSequence)" END -->\n");
        }
    }

    @Override
    protected void onDetach() {
        if (log.isDebugEnabled()) {
            log.debug("ending request for page " + this + ", request " + this.getRequest());
        }
        this.setFlag(1024, false);
        super.onDetach();
    }

    @Override
    protected void onRender() {
        MarkupStream markupStream = new MarkupStream(this.getMarkup());
        this.renderAll(markupStream, null);
    }

    final void componentAdded(Component component) {
        if (!component.isAuto()) {
            this.dirty();
        }
    }

    final void componentModelChanging(Component component) {
        this.dirty();
    }

    final void componentRemoved(Component component) {
        if (!component.isAuto()) {
            this.dirty();
        }
    }

    final void componentStateChanging(Component component) {
        if (!component.isAuto()) {
            this.dirty();
        }
    }

    void setPageStateless(Boolean stateless) {
        this.stateless = stateless;
    }

    @Override
    public MarkupType getMarkupType() {
        throw new UnsupportedOperationException("Page does not support markup. This error can happen if you have extended Page directly, instead extend WebPage");
    }

    public PageReference getPageReference() {
        this.setStatelessHint(false);
        return new PageReference(this.numericId);
    }

    @Override
    public int getPageId() {
        return this.numericId;
    }

    @Override
    public int getRenderCount() {
        return this.renderCount;
    }

    public final void setWasCreatedBookmarkable(boolean wasCreatedBookmarkable) {
        this.setFlag(524288, wasCreatedBookmarkable);
    }

    @Override
    public final boolean wasCreatedBookmarkable() {
        return this.getFlag(524288);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderPage() {
        boolean frozen = this.setFreezePageId(true);
        try {
            ++this.renderCount;
            this.render();
        }
        finally {
            this.setFreezePageId(frozen);
        }
    }

    public final boolean wasRendered(Component component) {
        return this.renderedComponents != null && this.renderedComponents.contains(component);
    }
}

