/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.List;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.AbstractSingleSelectChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.IOnChangeListener;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.handler.ListenerInterfaceRequestHandler;
import org.apache.wicket.request.handler.PageAndComponentProvider;
import org.apache.wicket.request.mapper.parameter.PageParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropDownChoice<T>
extends AbstractSingleSelectChoice<T>
implements IOnChangeListener {
    private static final long serialVersionUID = 1L;

    public DropDownChoice(String id) {
        super(id);
    }

    public DropDownChoice(String id, List<? extends T> choices) {
        super(id, choices);
    }

    public DropDownChoice(String id, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
    }

    public DropDownChoice(String id, IModel<T> model, List<? extends T> choices) {
        super(id, model, choices);
    }

    public DropDownChoice(String id, IModel<T> model, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model, choices, renderer);
    }

    public DropDownChoice(String id, IModel<? extends List<? extends T>> choices) {
        super(id, choices);
    }

    public DropDownChoice(String id, IModel<T> model, IModel<? extends List<? extends T>> choices) {
        super(id, model, choices);
    }

    public DropDownChoice(String id, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
    }

    public DropDownChoice(String id, IModel<T> model, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model, choices, renderer);
    }

    @Override
    public final void onSelectionChanged() {
        this.convertInput();
        this.updateModel();
        this.onSelectionChanged(this.getModelObject());
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "select");
        if (this.wantOnSelectionChangedNotifications()) {
            CharSequence url = this.urlFor(new ListenerInterfaceRequestHandler(new PageAndComponentProvider(this.getPage(), this, new PageParameters()), IOnChangeListener.INTERFACE));
            Form form = this.findParent(Form.class);
            if (form != null) {
                tag.put("onchange", form.getJsForInterfaceUrl(((Object)url).toString()));
            } else {
                tag.put("onchange", "window.location.href='" + url + (((Object)url).toString().indexOf(63) > -1 ? "&" : "?") + this.getInputName() + "=' + this.options[this.selectedIndex].value;");
            }
        }
        super.onComponentTag(tag);
    }

    protected void onSelectionChanged(T newSelection) {
    }

    protected boolean wantOnSelectionChangedNotifications() {
        return false;
    }

    @Override
    protected boolean getStatelessHint() {
        if (this.wantOnSelectionChangedNotifications()) {
            return false;
        }
        return super.getStatelessHint();
    }
}

