/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.AbstractSubmitLink;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmitLink
extends AbstractSubmitLink {
    private static final long serialVersionUID = 1L;

    public SubmitLink(String id) {
        super(id);
    }

    public SubmitLink(String id, Form<?> form) {
        super(id, form);
    }

    public SubmitLink(String id, IModel<?> model) {
        super(id, model);
    }

    public SubmitLink(String id, IModel<?> model, Form<?> form) {
        super(id, model, form);
    }

    public final void onLinkClicked() {
        this.onSubmit();
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (!this.isLinkEnabled()) {
            this.disableLink(tag);
        } else {
            if (tag.getName().equalsIgnoreCase("a")) {
                tag.put("href", "#");
            }
            tag.put("onclick", this.getTriggerJavaScript());
        }
    }

    protected boolean shouldInvokeJavaScriptFormOnsubmit() {
        return true;
    }

    protected String getTriggerJavaScript() {
        if (this.getForm() != null) {
            Form<?> root = this.getForm().getRootForm();
            StringBuilder sb = new StringBuilder(100);
            sb.append("var e=document.getElementById('");
            sb.append(root.getHiddenFieldId());
            sb.append("'); e.name='");
            sb.append(this.getInputName());
            sb.append("'; e.value='x';");
            sb.append("var f=document.getElementById('");
            sb.append(root.getMarkupId());
            sb.append("');");
            if (this.shouldInvokeJavaScriptFormOnsubmit()) {
                if (this.getForm() != root) {
                    sb.append("var ff=document.getElementById('");
                    sb.append(this.getForm().getMarkupId());
                    sb.append("');");
                } else {
                    sb.append("var ff=f;");
                }
                sb.append("if (ff.onsubmit != undefined) { if (ff.onsubmit()==false) return false; }");
            }
            sb.append("f.submit();e.value='';e.name='';return false;");
            return sb.toString();
        }
        return null;
    }

    @Override
    public void onSubmit() {
    }

    @Override
    public void onError() {
    }

    @Override
    public void onAfterSubmit() {
    }
}

