/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.renderStrategy;

import java.util.Iterator;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.renderStrategy.ChildFirstHeaderRenderStrategy;
import org.apache.wicket.markup.renderStrategy.IHeaderRenderStrategy;
import org.apache.wicket.util.lang.Args;

public abstract class AbstractHeaderRenderStrategy
implements IHeaderRenderStrategy {
    public static IHeaderRenderStrategy get() {
        String className = System.getProperty("Wicket_HeaderRenderStrategy");
        if (className != null) {
            Class<?> clazz = null;
            try {
                clazz = Application.get().getApplicationSettings().getClassResolver().resolveClass(className);
                if (clazz != null) {
                    return (IHeaderRenderStrategy)clazz.newInstance();
                }
            }
            catch (ClassNotFoundException ex) {
            }
            catch (InstantiationException ex) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return new ChildFirstHeaderRenderStrategy();
    }

    public void renderHeader(HtmlHeaderContainer headerContainer, Component rootComponent) {
        Args.notNull((Object)headerContainer, (String)"headerContainer");
        Args.notNull((Object)rootComponent, (String)"rootComponent");
        this.renderApplicationLevelHeaders(headerContainer);
        this.renderRootComponent(headerContainer, rootComponent);
        this.renderChildHeaders(headerContainer, rootComponent);
    }

    protected void renderRootComponent(HtmlHeaderContainer headerContainer, Component rootComponent) {
        rootComponent.renderHead(headerContainer);
    }

    protected abstract void renderChildHeaders(HtmlHeaderContainer var1, Component var2);

    protected final void renderApplicationLevelHeaders(HtmlHeaderContainer headerContainer) {
        Args.notNull((Object)headerContainer, (String)"headerContainer");
        if (Application.exists()) {
            Iterator i$ = Application.get().getHeaderContributorListenerCollection().iterator();
            while (i$.hasNext()) {
                IHeaderContributor listener = (IHeaderContributor)i$.next();
                listener.renderHead(headerContainer.getHeaderResponse());
            }
        }
    }
}

