/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.repeater.data;

import java.util.Iterator;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.markup.repeater.data.DataViewBase;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GridView<T>
extends DataViewBase<T> {
    private static final long serialVersionUID = 1L;
    private int columns = 1;
    private int rows = Integer.MAX_VALUE;

    public GridView(String id, IDataProvider<T> dataProvider) {
        super(id, dataProvider);
    }

    public int getColumns() {
        return this.columns;
    }

    public GridView<T> setColumns(int cols) {
        if (cols < 1) {
            throw new IllegalArgumentException();
        }
        if (this.columns != cols) {
            if (this.isVersioned()) {
                this.addStateChange();
            }
            this.columns = cols;
        }
        this.updateItemsPerPage();
        return this;
    }

    public int getRows() {
        return this.rows;
    }

    public GridView<T> setRows(int rows) {
        if (rows < 1) {
            throw new IllegalArgumentException();
        }
        if (this.rows != rows) {
            if (this.isVersioned()) {
                this.addStateChange();
            }
            this.rows = rows;
        }
        this.updateItemsPerPage();
        return this;
    }

    private void updateItemsPerPage() {
        int items = Integer.MAX_VALUE;
        long result = (long)this.rows * (long)this.columns;
        int desiredHiBits = -((int)(result >>> 31) & 1);
        int actualHiBits = (int)(result >>> 32);
        if (desiredHiBits == actualHiBits) {
            items = (int)result;
        }
        this.setItemsPerPage(items);
    }

    @Override
    protected void addItems(Iterator<Item<T>> items) {
        if (items.hasNext()) {
            int cols = this.getColumns();
            int row = 0;
            do {
                Item<?> rowItem = this.newRowItem(this.newChildId(), row);
                RepeatingView rowView = new RepeatingView("cols");
                rowItem.add(rowView);
                this.add(rowItem);
                for (int index = 0; index < cols; ++index) {
                    Item<T> cellItem;
                    if (items.hasNext()) {
                        cellItem = items.next();
                    } else {
                        cellItem = this.newEmptyItem(this.newChildId(), index);
                        this.populateEmptyItem(cellItem);
                    }
                    rowView.add(cellItem);
                }
                ++row;
            } while (items.hasNext());
        }
    }

    public IDataProvider<T> getDataProvider() {
        return this.internalGetDataProvider();
    }

    @Override
    public Iterator<Item<T>> getItems() {
        Iterator rows = Generics.iterator(this.iterator());
        return new ItemsIterator(rows);
    }

    protected abstract void populateEmptyItem(Item<T> var1);

    protected Item<T> newEmptyItem(String id, int index) {
        return new Item(id, index, null);
    }

    protected Item<?> newRowItem(String id, int index) {
        return new Item(id, index, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ItemsIterator<T>
    implements Iterator<Item<T>> {
        private final Iterator<MarkupContainer> rows;
        private Iterator<Item<T>> cells;
        private Item<T> next;

        public ItemsIterator(Iterator<MarkupContainer> rows) {
            this.rows = (Iterator)Args.notNull(rows, (String)"rows");
            this.findNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Item<T> next() {
            Item<T> item = this.next;
            this.findNext();
            return item;
        }

        private void findNext() {
            this.next = null;
            if (this.cells != null && this.cells.hasNext()) {
                this.next = this.cells.next();
            } else {
                while (this.rows.hasNext()) {
                    MarkupContainer row = this.rows.next();
                    Iterator<Component> rawCells = ((MarkupContainer)row.iterator().next()).iterator();
                    this.cells = Generics.iterator(rawCells);
                    if (!this.cells.hasNext()) continue;
                    this.next = this.cells.next();
                    break;
                }
            }
        }
    }
}

