/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import java.util.regex.Pattern;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.wicket.protocol.http.servlet.AbstractRequestWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecuredRemoteAddressRequestWrapperFactory
extends AbstractRequestWrapperFactory {
    private static final Logger log = LoggerFactory.getLogger(SecuredRemoteAddressRequestWrapperFactory.class);
    private static final String SECURED_REMOTE_ADDRESSES_PARAMETER = "securedRemoteAddresses";
    private Config config = new Config();

    public final Config getConfig() {
        return this.config;
    }

    public final void setConfig(Config config) {
        this.config = config;
    }

    public HttpServletRequest getWrapper(HttpServletRequest request) {
        HttpServletRequest xRequest = super.getWrapper(request);
        if (log.isDebugEnabled()) {
            log.debug("Incoming request uri=" + request.getRequestURI() + " with originalSecure='" + request.isSecure() + "', remoteAddr='" + request.getRemoteAddr() + "' will be seen with newSecure='" + request.isSecure() + "'");
        }
        return xRequest;
    }

    public boolean needsWrapper(HttpServletRequest request) {
        return !request.isSecure() && !SecuredRemoteAddressRequestWrapperFactory.matchesOne(request.getRemoteAddr(), this.config.securedRemoteAddresses);
    }

    public HttpServletRequest newRequestWrapper(HttpServletRequest request) {
        return new HttpServletRequestWrapper(request){

            public boolean isSecure() {
                return true;
            }
        };
    }

    public void init(FilterConfig filterConfig) {
        String comaDelimitedSecuredRemoteAddresses = filterConfig.getInitParameter(SECURED_REMOTE_ADDRESSES_PARAMETER);
        if (comaDelimitedSecuredRemoteAddresses != null) {
            this.config.setSecuredRemoteAdresses(comaDelimitedSecuredRemoteAddresses);
        }
    }

    public static class Config {
        private Pattern[] securedRemoteAddresses = new Pattern[]{Pattern.compile("10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}"), Pattern.compile("192\\.168\\.\\d{1,3}\\.\\d{1,3}"), Pattern.compile("172\\.(?:1[6-9]|2\\d|3[0-1]).\\d{1,3}.\\d{1,3}"), Pattern.compile("169\\.254\\.\\d{1,3}\\.\\d{1,3}"), Pattern.compile("127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}")};

        public void setSecuredRemoteAdresses(String comaDelimitedSecuredRemoteAddresses) {
            this.securedRemoteAddresses = AbstractRequestWrapperFactory.commaDelimitedListToPatternArray(comaDelimitedSecuredRemoteAddresses);
        }
    }
}

