/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.cycle;

import org.apache.wicket.MetaDataKey;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.AbstractRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.IPageRequestHandler;

public class PageRequestHandlerTracker
extends AbstractRequestCycleListener {
    public static final MetaDataKey<IPageRequestHandler> FIRST_HANDLER_KEY = new MetaDataKey<IPageRequestHandler>(){};
    public static final MetaDataKey<IPageRequestHandler> LAST_HANDLER_KEY = new MetaDataKey<IPageRequestHandler>(){};

    public void onRequestHandlerResolved(RequestCycle cycle, IRequestHandler handler) {
        super.onRequestHandlerResolved(cycle, handler);
        this.registerFirstHandler(cycle, handler);
        this.registerLastHandler(cycle, handler);
    }

    public void onRequestHandlerScheduled(RequestCycle cycle, IRequestHandler handler) {
        super.onRequestHandlerResolved(cycle, handler);
        this.registerLastHandler(cycle, handler);
    }

    public void onExceptionRequestHandlerResolved(RequestCycle cycle, IRequestHandler handler, Exception exception) {
        super.onExceptionRequestHandlerResolved(cycle, handler, exception);
        this.registerLastHandler(cycle, handler);
    }

    private void registerLastHandler(RequestCycle cycle, IRequestHandler handler) {
        if (handler instanceof IPageRequestHandler) {
            cycle.setMetaData(LAST_HANDLER_KEY, (IPageRequestHandler)handler);
        }
    }

    private void registerFirstHandler(RequestCycle cycle, IRequestHandler handler) {
        if (handler instanceof IPageRequestHandler && PageRequestHandlerTracker.getFirstHandler(cycle) == null) {
            cycle.setMetaData(FIRST_HANDLER_KEY, (IPageRequestHandler)handler);
        }
    }

    public static IPageRequestHandler getLastHandler(RequestCycle cycle) {
        return cycle.getMetaData(LAST_HANDLER_KEY);
    }

    public static IPageRequestHandler getFirstHandler(RequestCycle cycle) {
        return cycle.getMetaData(FIRST_HANDLER_KEY);
    }
}

