/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.handler.resource;

import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.WebExternalResourceStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebExternalResourceRequestHandler
extends ResourceStreamRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(WebExternalResourceRequestHandler.class);
    private final String uri;

    public WebExternalResourceRequestHandler(String uri) {
        super((IResourceStream)new WebExternalResourceStream(uri));
        this.uri = uri;
        this.setContentDisposition(ContentDisposition.INLINE);
    }

    public final String getUrl() {
        return this.uri;
    }

    public void detach(IRequestCycle requestCycle) {
    }

    public boolean equals(Object obj) {
        if (obj instanceof WebExternalResourceRequestHandler) {
            WebExternalResourceRequestHandler that = (WebExternalResourceRequestHandler)obj;
            return this.uri.equals(that.uri);
        }
        return false;
    }

    public int hashCode() {
        int result = "WebExternalResourceRequestTarget".hashCode();
        return 17 * (result += this.uri.hashCode());
    }

    public String toString() {
        return "[WebExternalResourceRequestTarget@" + this.hashCode() + " " + this.uri + "]";
    }
}

