/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource.dependencies;

import org.apache.wicket.markup.html.DecoratingHeaderResponse;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.ResourceUtil;
import org.apache.wicket.resource.dependencies.AbstractResourceDependentResourceReference;
import org.apache.wicket.resource.dependencies.IResourceReferenceDependencyConfigurationService;

public class ResourceReferenceDependencyInjectingHeaderResponse
extends DecoratingHeaderResponse {
    private final IResourceReferenceDependencyConfigurationService configurationService;

    public ResourceReferenceDependencyInjectingHeaderResponse(IHeaderResponse decorated) {
        this(decorated, null);
    }

    public ResourceReferenceDependencyInjectingHeaderResponse(IHeaderResponse decorated, IResourceReferenceDependencyConfigurationService configurator) {
        super(decorated);
        this.configurationService = configurator;
    }

    public IResourceReferenceDependencyConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            throw new IllegalStateException("you must either provide an IResourceReferenceDependencyConfigurationService at construction time or override getConfigurationService()");
        }
        return this.configurationService;
    }

    public void renderCSSReference(ResourceReference reference) {
        this.render(this.get(reference));
    }

    public void renderCSSReference(ResourceReference reference, String media) {
        AbstractResourceDependentResourceReference parent = this.get(reference);
        parent.setMedia(media);
        this.render(parent);
    }

    public void renderJavaScriptReference(ResourceReference reference) {
        this.render(this.get(reference));
    }

    public void renderJavaScriptReference(ResourceReference reference, String id) {
        AbstractResourceDependentResourceReference parent = this.get(reference);
        parent.setUniqueId(id);
        this.render(parent);
    }

    protected void render(AbstractResourceDependentResourceReference parent) {
        for (AbstractResourceDependentResourceReference child : parent.getDependentResourceReferences()) {
            this.render(child);
        }
        boolean css = AbstractResourceDependentResourceReference.ResourceType.CSS.equals((Object)parent.getResourceType());
        String string = css ? parent.getMedia() : parent.getUniqueId();
        ResourceUtil.renderTo(this.getRealResponse(), parent, css, string);
    }

    private AbstractResourceDependentResourceReference get(ResourceReference reference) {
        AbstractResourceDependentResourceReference ref = this.getConfigurationService().configure(reference);
        if (ref == null) {
            throw new IllegalStateException("your IResourceReferenceDependencyConfigurationService can not return null from configure");
        }
        return ref;
    }
}

