/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.serialize.java;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import org.apache.wicket.Application;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.application.IClassResolver;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.settings.IApplicationSettings;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.io.SerializableChecker;
import org.apache.wicket.util.objects.checker.CheckingObjectOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSerializer
implements ISerializer {
    private static final Logger log = LoggerFactory.getLogger(JavaSerializer.class);
    private final String applicationKey;

    public JavaSerializer(String applicationKey) {
        this.applicationKey = applicationKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize(Object object) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream oos = null;
            try {
                oos = this.newObjectOutputStream(out);
                oos.writeObject(this.applicationKey);
                oos.writeObject(object);
            }
            finally {
                try {
                    IOUtils.close((Closeable)oos);
                }
                finally {
                    out.close();
                }
            }
            return out.toByteArray();
        }
        catch (Exception e) {
            log.error("Error serializing object " + object.getClass() + " [object=" + object + "]", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deserialize(byte[] data) {
        ThreadContext old = ThreadContext.get(false);
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        ObjectInputStream ois = null;
        try {
            Object object;
            Application oldApplication = ThreadContext.getApplication();
            try {
                Application app;
                ois = this.newObjectInputStream(in);
                String applicationName = (String)ois.readObject();
                if (applicationName != null && (app = Application.get(applicationName)) != null) {
                    ThreadContext.setApplication(app);
                }
                object = ois.readObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ThreadContext.setApplication(oldApplication);
                        IOUtils.close((Closeable)ois);
                    }
                    finally {
                        in.close();
                    }
                    throw throwable;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Could not deserialize object using: " + ois.getClass(), e);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not deserialize object using: " + ois.getClass(), e);
                }
            }
            try {
                ThreadContext.setApplication(oldApplication);
                IOUtils.close((Closeable)ois);
            }
            finally {
                in.close();
            }
            return object;
        }
        finally {
            ThreadContext.restore(old);
        }
    }

    protected ObjectInputStream newObjectInputStream(InputStream in) throws IOException {
        return new ClassResolverObjectInputStream(in);
    }

    protected ObjectOutputStream newObjectOutputStream(OutputStream out) throws IOException {
        return new SerializationCheckingObjectOutputStream(out);
    }

    private static class SerializationCheckingObjectOutputStream
    extends ObjectOutputStream {
        private final OutputStream outputStream;
        private final ObjectOutputStream oos;

        private SerializationCheckingObjectOutputStream(OutputStream outputStream) throws IOException {
            this.outputStream = outputStream;
            this.oos = new ObjectOutputStream(outputStream);
        }

        protected final void writeObjectOverride(Object obj) throws IOException {
            try {
                this.oos.writeObject(obj);
            }
            catch (NotSerializableException nsx) {
                if (CheckingObjectOutputStream.isAvailable()) {
                    new SerializableChecker(this.outputStream, nsx).writeObject(obj);
                    throw nsx;
                }
                throw nsx;
            }
            catch (Exception e) {
                log.error("error writing object " + obj + ": " + e.getMessage(), (Throwable)e);
                throw new WicketRuntimeException(e);
            }
        }

        public void flush() throws IOException {
            this.oos.flush();
        }

        public void close() throws IOException {
            this.oos.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassResolverObjectInputStream
    extends ObjectInputStream {
        public ClassResolverObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String className = desc.getName();
            try {
                return super.resolveClass(desc);
            }
            catch (ClassNotFoundException ex1) {
                Class<?> candidate;
                block5: {
                    log.debug("Class not found by the object outputstream itself, trying the IClassResolver");
                    candidate = null;
                    try {
                        Application application = Application.get();
                        IApplicationSettings applicationSettings = application.getApplicationSettings();
                        IClassResolver classResolver = applicationSettings.getClassResolver();
                        candidate = classResolver.resolveClass(className);
                        if (candidate == null) {
                            candidate = super.resolveClass(desc);
                        }
                    }
                    catch (WicketRuntimeException ex) {
                        if (!(ex.getCause() instanceof ClassNotFoundException)) break block5;
                        throw (ClassNotFoundException)ex.getCause();
                    }
                }
                return candidate;
            }
        }
    }
}

