/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.session;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.session.ISessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSessionStore
implements ISessionStore {
    private static Logger log = LoggerFactory.getLogger(HttpSessionStore.class);
    private final Set<ISessionStore.UnboundListener> unboundListeners = new CopyOnWriteArraySet<ISessionStore.UnboundListener>();
    private final Set<ISessionStore.BindListener> bindListeners = new CopyOnWriteArraySet<ISessionStore.BindListener>();

    protected final HttpServletRequest getHttpServletRequest(Request request) {
        Object containerRequest = request.getContainerRequest();
        if (containerRequest == null || !(containerRequest instanceof HttpServletRequest)) {
            throw new IllegalArgumentException("Request must be ServletWebRequest");
        }
        return (HttpServletRequest)containerRequest;
    }

    final HttpSession getHttpSession(Request request, boolean create) {
        return this.getHttpServletRequest(request).getSession(create);
    }

    @Override
    public final void bind(Request request, Session newSession) {
        if (this.getAttribute(request, "session") != newSession) {
            this.onBind(request, newSession);
            for (ISessionStore.BindListener listener : this.getBindListeners()) {
                listener.bindingSession(request, newSession);
            }
            HttpSession httpSession = this.getHttpSession(request, false);
            if (httpSession != null) {
                String applicationKey = Application.get().getName();
                httpSession.setAttribute("Wicket:SessionUnbindingListener-" + applicationKey, (Object)new SessionBindingListener(applicationKey, newSession));
                this.setAttribute(request, "session", (Serializable)((Object)newSession));
            }
        }
    }

    @Override
    public void flushSession(Request request, Session session) {
        if (this.getAttribute(request, "session") != session) {
            this.bind(request, session);
        } else {
            this.setAttribute(request, "session", (Serializable)((Object)session));
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public String getSessionId(Request request, boolean create) {
        String id = null;
        HttpSession httpSession = this.getHttpSession(request, false);
        if (httpSession != null) {
            id = httpSession.getId();
        } else if (create) {
            httpSession = this.getHttpSession(request, true);
            id = httpSession.getId();
            IRequestLogger logger = Application.get().getRequestLogger();
            if (logger != null) {
                logger.sessionCreated(id);
            }
        }
        return id;
    }

    @Override
    public final void invalidate(Request request) {
        HttpSession httpSession = this.getHttpSession(request, false);
        if (httpSession != null) {
            httpSession.invalidate();
        }
    }

    @Override
    public final Session lookup(Request request) {
        String sessionId = this.getSessionId(request, false);
        if (sessionId != null) {
            return (Session)((Object)this.getAttribute(request, "session"));
        }
        return null;
    }

    protected void onBind(Request request, Session newSession) {
    }

    protected void onUnbind(String sessionId) {
    }

    private String getSessionAttributePrefix(Request request) {
        String sessionAttributePrefix = "wicket";
        if (request instanceof WebRequest) {
            sessionAttributePrefix = WebApplication.get().getSessionAttributePrefix((WebRequest)request, null);
        }
        return sessionAttributePrefix;
    }

    @Override
    public final Serializable getAttribute(Request request, String name) {
        HttpSession httpSession = this.getHttpSession(request, false);
        if (httpSession != null) {
            return (Serializable)httpSession.getAttribute(this.getSessionAttributePrefix(request) + name);
        }
        return null;
    }

    @Override
    public final List<String> getAttributeNames(Request request) {
        ArrayList<String> list = new ArrayList<String>();
        HttpSession httpSession = this.getHttpSession(request, false);
        if (httpSession != null) {
            Enumeration names = httpSession.getAttributeNames();
            String prefix = this.getSessionAttributePrefix(request);
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.startsWith(prefix)) continue;
                list.add(name.substring(prefix.length()));
            }
        }
        return list;
    }

    @Override
    public final void removeAttribute(Request request, String name) {
        HttpSession httpSession = this.getHttpSession(request, false);
        if (httpSession != null) {
            Object value;
            String attributeName = this.getSessionAttributePrefix(request) + name;
            IRequestLogger logger = Application.get().getRequestLogger();
            if (logger != null && (value = httpSession.getAttribute(attributeName)) != null) {
                logger.objectRemoved(value);
            }
            httpSession.removeAttribute(attributeName);
        }
    }

    @Override
    public final void setAttribute(Request request, String name, Serializable value) {
        HttpSession httpSession = this.getHttpSession(request, false);
        if (httpSession != null) {
            String attributeName = this.getSessionAttributePrefix(request) + name;
            IRequestLogger logger = Application.get().getRequestLogger();
            if (logger != null) {
                if (httpSession.getAttribute(attributeName) == null) {
                    logger.objectCreated(value);
                } else {
                    logger.objectUpdated(value);
                }
            }
            httpSession.setAttribute(attributeName, (Object)value);
        }
    }

    @Override
    public final void registerUnboundListener(ISessionStore.UnboundListener listener) {
        this.unboundListeners.add(listener);
    }

    @Override
    public final void unregisterUnboundListener(ISessionStore.UnboundListener listener) {
        this.unboundListeners.remove(listener);
    }

    @Override
    public final Set<ISessionStore.UnboundListener> getUnboundListener() {
        return Collections.unmodifiableSet(this.unboundListeners);
    }

    public void registerBindListener(ISessionStore.BindListener listener) {
        this.bindListeners.add(listener);
    }

    public void unregisterBindListener(ISessionStore.BindListener listener) {
        this.bindListeners.remove(listener);
    }

    public Set<ISessionStore.BindListener> getBindListeners() {
        return Collections.unmodifiableSet(this.bindListeners);
    }

    protected static final class SessionBindingListener
    implements HttpSessionBindingListener,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String applicationKey;
        private final Session wicketSession;

        public SessionBindingListener(String applicationKey, Session wicketSession) {
            this.applicationKey = applicationKey;
            this.wicketSession = wicketSession;
        }

        public void valueBound(HttpSessionBindingEvent evg) {
        }

        public void valueUnbound(HttpSessionBindingEvent evt) {
            Application application;
            String sessionId = evt.getSession().getId();
            if (log.isDebugEnabled()) {
                log.debug("Session unbound: " + sessionId);
            }
            if (this.wicketSession != null) {
                this.wicketSession.onInvalidate();
            }
            if ((application = Application.get(this.applicationKey)) == null) {
                log.debug("Wicket application with name '" + this.applicationKey + "' not found.");
                return;
            }
            ISessionStore sessionStore = application.getSessionStore();
            if (sessionStore != null) {
                if (sessionStore instanceof HttpSessionStore) {
                    ((HttpSessionStore)sessionStore).onUnbind(sessionId);
                }
                for (ISessionStore.UnboundListener listener : sessionStore.getUnboundListener()) {
                    listener.sessionUnbound(sessionId);
                }
            }
        }
    }
}

