/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource.locator;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.util.file.IResourceFinder;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceUtils;
import org.apache.wicket.util.resource.UrlResourceStream;
import org.apache.wicket.util.resource.locator.EmptyResourceNameIterator;
import org.apache.wicket.util.resource.locator.IResourceStreamLocator;
import org.apache.wicket.util.resource.locator.ResourceNameIterator;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceStreamLocator
implements IResourceStreamLocator {
    private static final Logger log = LoggerFactory.getLogger(ResourceStreamLocator.class);
    private IResourceFinder finder;
    private final List<String> classpathLocationPrefixes = new LinkedList<String>();

    public ResourceStreamLocator() {
        this.classpathLocationPrefixes.add("");
        this.classpathLocationPrefixes.add("META-INF/resources");
    }

    public ResourceStreamLocator(IResourceFinder finder) {
        this.classpathLocationPrefixes.add("");
        this.classpathLocationPrefixes.add("META-INF/resources");
        this.finder = finder;
    }

    @Override
    public IResourceStream locate(Class<?> clazz, String path) {
        IResourceStream stream = this.locateByResourceFinder(clazz, path);
        if (stream != null) {
            return stream;
        }
        stream = this.locateByClassLoader(clazz, path);
        if (stream != null) {
            return stream;
        }
        return null;
    }

    @Override
    public IResourceStream locate(Class<?> clazz, String path, String style, String variation, Locale locale, String extension, boolean strict) {
        ResourceUtils.PathLocale data = ResourceUtils.getLocaleFromFilename((String)path);
        if (data != null && data.locale != null) {
            path = data.path;
            locale = data.locale;
        }
        ResourceNameIterator iter = this.newResourceNameIterator(path, locale, style, variation, extension, strict);
        while (iter.hasNext()) {
            String newPath = iter.next();
            IResourceStream stream = this.locate(clazz, newPath);
            if (stream == null) continue;
            stream.setLocale(iter.getLocale());
            stream.setStyle(iter.getStyle());
            stream.setVariation(iter.getVariation());
            return stream;
        }
        return null;
    }

    protected IResourceStream locateByClassLoader(Class<?> clazz, String path) {
        IResourceStream resourceStream = null;
        if (clazz != null && (resourceStream = this.getResourceStream(clazz.getClassLoader(), path)) != null) {
            return resourceStream;
        }
        resourceStream = this.getResourceStream(Thread.currentThread().getContextClassLoader(), path);
        if (resourceStream != null) {
            return resourceStream;
        }
        resourceStream = this.getResourceStream(this.getClass().getClassLoader(), path);
        if (resourceStream != null) {
            return resourceStream;
        }
        return null;
    }

    private IResourceStream getResourceStream(ClassLoader classLoader, String path) {
        if (classLoader == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Attempting to locate resource '" + path + "' using classloader " + classLoader);
        }
        for (String prefix : this.classpathLocationPrefixes) {
            String fullPath = prefix.length() > 0 ? prefix + "/" + path : path;
            URL url = classLoader.getResource(fullPath);
            if (url == null) continue;
            return new UrlResourceStream(url);
        }
        return null;
    }

    protected IResourceStream locateByResourceFinder(Class<?> clazz, String path) {
        if (this.finder == null) {
            this.finder = Application.get().getResourceSettings().getResourceFinder();
        }
        if (log.isDebugEnabled()) {
            log.debug("Attempting to locate resource '" + path + "' on path " + this.finder);
        }
        return this.finder.find(clazz, path);
    }

    @Override
    public ResourceNameIterator newResourceNameIterator(String path, Locale locale, String style, String variation, String extension, boolean strict) {
        String realExtension;
        String realPath;
        if (extension == null && path != null && path.indexOf(46) != -1) {
            realPath = Strings.beforeLast((String)path, (char)'.');
            realExtension = Strings.afterLast((String)path, (char)'.');
            if (realExtension.indexOf(44) > -1) {
                return new EmptyResourceNameIterator();
            }
        } else {
            realPath = path;
            realExtension = extension;
        }
        return new ResourceNameIterator(realPath, style, variation, locale, realExtension, strict);
    }

    public List<String> getClasspathLocationPrefixes() {
        return this.classpathLocationPrefixes;
    }
}

