/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.wicket.authorization;

import org.apache.wicket.request.component.IRequestableComponent;
import org.apache.wicket.util.lang.WicketObjects;

/**
 * Exception that is thrown when the creation of a component is not allowed.
 * 
 * @author Eelco Hillenius
 * @author Jonathan Locke
 */
public class UnauthorizedInstantiationException extends AuthorizationException
{
	private static final long serialVersionUID = 1L;

	/** The component class that could not be instantiated */
	private final String componentClassName;

	/**
	 * Construct.
	 * 
	 * @param <T>
	 *            The component type.
	 * 
	 * @param componentClass
	 *            The unauthorized component class
	 */
	public <T extends IRequestableComponent> UnauthorizedInstantiationException(
		final Class<T> componentClass)
	{
		super("Not authorized to instantiate class " + componentClass.getName());
		componentClassName = componentClass.getName();
	}

	/**
	 * @return The component class that could not be instantiated
	 */
	public Class<? extends IRequestableComponent> getComponentClass()
	{
		return WicketObjects.resolveClass(componentClassName);
	}
}
