/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.feedback;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.StringList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FeedbackMessages
implements IClusterable,
Iterable<FeedbackMessage> {
    private static final Logger log = LoggerFactory.getLogger(FeedbackMessages.class);
    private static final long serialVersionUID = 1L;
    private final List<FeedbackMessage> messages = new CopyOnWriteArrayList<FeedbackMessage>();

    public final void add(FeedbackMessage message) {
        if (log.isDebugEnabled()) {
            log.debug("Adding feedback message " + message);
        }
        this.messages.add(message);
    }

    public final void add(Component reporter, Serializable message, int level) {
        this.add(new FeedbackMessage(reporter, message, level));
    }

    public final void debug(Component reporter, Serializable message) {
        this.add(new FeedbackMessage(reporter, message, 100));
    }

    public final void info(Component reporter, Serializable message) {
        this.add(new FeedbackMessage(reporter, message, 200));
    }

    public final void success(Component reporter, Serializable message) {
        this.add(new FeedbackMessage(reporter, message, 250));
    }

    public final void warn(Component reporter, Serializable message) {
        this.add(new FeedbackMessage(reporter, message, 300));
    }

    public final void error(Component reporter, Serializable message) {
        this.add(new FeedbackMessage(reporter, message, 400));
    }

    public final void fatal(Component reporter, Serializable message) {
        this.add(new FeedbackMessage(reporter, message, 500));
    }

    public final int clear() {
        return this.clear(null);
    }

    public final int clear(IFeedbackMessageFilter filter) {
        if (this.messages.isEmpty()) {
            return 0;
        }
        List<FeedbackMessage> toDelete = this.messages(filter);
        for (FeedbackMessage message : toDelete) {
            message.detach();
        }
        this.messages.removeAll(toDelete);
        return toDelete.size();
    }

    public final boolean hasMessage(IFeedbackMessageFilter filter) {
        for (FeedbackMessage message : this.messages) {
            if (filter != null && !filter.accept(message)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasMessageFor(Component component) {
        return this.hasMessage(new ComponentFeedbackMessageFilter(component));
    }

    public final boolean hasMessageFor(final Component component, final int level) {
        return this.hasMessage(new IFeedbackMessageFilter(){

            public boolean accept(FeedbackMessage message) {
                return Objects.equal((Object)message.getReporter(), (Object)component) && message.isLevel(level);
            }
        });
    }

    public final boolean hasErrorMessageFor(Component component) {
        return this.hasMessageFor(component, 400);
    }

    @Override
    public final Iterator<FeedbackMessage> iterator() {
        return this.messages.iterator();
    }

    public final List<FeedbackMessage> messages(IFeedbackMessageFilter filter) {
        if (this.messages.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FeedbackMessage> list = new ArrayList<FeedbackMessage>();
        for (FeedbackMessage message : this.messages) {
            if (filter != null && !filter.accept(message)) continue;
            list.add(message);
        }
        return list;
    }

    public final FeedbackMessage messageForComponent(Component component) {
        List<FeedbackMessage> list = this.messagesForComponent(component);
        return list.isEmpty() ? null : list.get(0);
    }

    public final List<FeedbackMessage> messagesForComponent(Component component) {
        return this.messages(new ComponentFeedbackMessageFilter(component));
    }

    public final boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public final int size() {
        return this.messages.size();
    }

    public final int size(IFeedbackMessageFilter filter) {
        int count = 0;
        for (FeedbackMessage message : this.messages) {
            if (filter != null && !filter.accept(message)) continue;
            ++count;
        }
        return count;
    }

    public String toString() {
        return "[feedbackMessages = " + StringList.valueOf(this.messages) + ']';
    }
}

