/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.AbstractChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSingleSelectChoice<T>
extends AbstractChoice<T, T> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractSingleSelectChoice.class);
    private static final String CHOOSE_ONE = "Choose One";
    private boolean nullValid = false;

    public AbstractSingleSelectChoice(String id) {
        super(id);
    }

    public AbstractSingleSelectChoice(String id, List<? extends T> choices) {
        super(id, choices);
    }

    public AbstractSingleSelectChoice(String id, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
    }

    public AbstractSingleSelectChoice(String id, IModel<T> model, List<? extends T> choices) {
        super(id, model, choices);
    }

    public AbstractSingleSelectChoice(String id, IModel<T> model, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model, choices, renderer);
    }

    public AbstractSingleSelectChoice(String id, IModel<? extends List<? extends T>> choices) {
        super(id, choices);
    }

    public AbstractSingleSelectChoice(String id, IModel<T> model, IModel<? extends List<? extends T>> choices) {
        super(id, model, choices);
    }

    public AbstractSingleSelectChoice(String id, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
    }

    public AbstractSingleSelectChoice(String id, IModel<T> model, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model, choices, renderer);
    }

    @Override
    public String getModelValue() {
        Object object = this.getModelObject();
        if (object != null) {
            int index = this.getChoices().indexOf(object);
            if (index < 0) {
                logger.warn("Detected inconsistency in choice component: {}/{}. Model returned object: {}, but this object is not available in the list of selected objects.", new Object[]{this.getPage().getClass(), this.getPageRelativePath(), object});
                return "";
            }
            return this.getChoiceRenderer().getIdValue(object, index);
        }
        return "";
    }

    public boolean isNullValid() {
        return this.nullValid;
    }

    public AbstractSingleSelectChoice<T> setNullValid(boolean nullValid) {
        this.nullValid = nullValid;
        return this;
    }

    @Override
    protected final T convertValue(String[] value) {
        String tmp = value != null && value.length > 0 ? value[0] : null;
        return this.convertChoiceIdToChoice(tmp);
    }

    protected T convertChoiceIdToChoice(String id) {
        List choices = this.getChoices();
        IChoiceRenderer renderer = this.getChoiceRenderer();
        for (int index = 0; index < choices.size(); ++index) {
            Object choice = choices.get(index);
            if (!renderer.getIdValue(choice, index).equals(id)) continue;
            return (T)choice;
        }
        return null;
    }

    @Override
    protected CharSequence getDefaultChoice(String selectedValue) {
        if (this.isNullValid()) {
            String option = this.getLocalizer().getStringIgnoreSettings(this.getNullValidKey(), this, null, null);
            if (Strings.isEmpty((CharSequence)option)) {
                option = this.getLocalizer().getString("nullValid", (Component)this, "");
            }
            AppendingStringBuffer buffer = new AppendingStringBuffer(64 + option.length());
            buffer.append("\n<option");
            if ("".equals(selectedValue)) {
                buffer.append(" selected=\"selected\"");
            }
            buffer.append(" value=\"\">").append(option).append("</option>");
            return buffer;
        }
        if ("".equals(selectedValue)) {
            String option = this.getLocalizer().getStringIgnoreSettings(this.getNullKey(), this, null, null);
            if (Strings.isEmpty((CharSequence)option)) {
                option = this.getLocalizer().getString("null", (Component)this, CHOOSE_ONE);
            }
            return "\n<option selected=\"selected\" value=\"\">" + option + "</option>";
        }
        return "";
    }

    protected String getNullValidKey() {
        return this.getId() + ".nullValid";
    }

    protected String getNullKey() {
        return this.getId() + ".null";
    }

    @Override
    protected boolean isSelected(T object, int index, String selected) {
        return selected != null && selected.equals(this.getChoiceRenderer().getIdValue(object, index));
    }
}

