/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IObjectClassAwareModel;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTextComponent<T>
extends FormComponent<T> {
    private static final int TYPE_RESOLVED = 2048;
    private static final Logger log = LoggerFactory.getLogger(AbstractTextComponent.class);
    private static final long serialVersionUID = 1L;

    public AbstractTextComponent(String id) {
        this(id, (IModel<T>)null);
    }

    public AbstractTextComponent(String id, IModel<T> model) {
        super(id, model);
        this.setConvertEmptyInputStringToNull(true);
    }

    public final boolean getConvertEmptyInputStringToNull() {
        return this.getFlag(256);
    }

    @Override
    public boolean isInputNullable() {
        return false;
    }

    @Override
    protected void convertInput() {
        String tmp;
        this.resolveType();
        String[] value = this.getInputAsArray();
        String string = tmp = value != null && value.length > 0 ? value[0] : null;
        if (this.getConvertEmptyInputStringToNull() && Strings.isEmpty((CharSequence)tmp)) {
            this.setConvertedInput(null);
        } else {
            super.convertInput();
        }
    }

    @Override
    protected void onBeforeRender() {
        super.onBeforeRender();
        this.resolveType();
    }

    private void resolveType() {
        if (!this.getFlag(2048) && this.getType() == null) {
            Class<?> type = this.getModelType(this.getDefaultModel());
            this.setType(type);
            this.setFlag(2048, true);
        }
    }

    private Class<?> getModelType(IModel<?> model) {
        if (model instanceof IObjectClassAwareModel) {
            Class objectClass = ((IObjectClassAwareModel)model).getObjectClass();
            if (objectClass == null) {
                log.warn("Couldn't resolve model type of " + model + " for " + this + ", please set the type yourself.");
            }
            return objectClass;
        }
        return null;
    }

    public final FormComponent<T> setConvertEmptyInputStringToNull(boolean flag) {
        this.setFlag(256, flag);
        return this;
    }

    public static interface ITextFormatProvider {
        public String getTextFormat();
    }
}

