/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.Locale;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.value.IValueMap;
import org.apache.wicket.validation.validator.RangeValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberTextField<N extends Number>
extends TextField<N> {
    private static final long serialVersionUID = 1L;
    private RangeValidator<N> validator = null;
    private N minimum = null;
    private N maximum = null;

    public NumberTextField(String id) {
        this(id, (IModel<N>)null);
    }

    public NumberTextField(String id, IModel<N> model) {
        this(id, model, (Class<N>)null);
    }

    public NumberTextField(String id, IModel<N> model, Class<N> type) {
        super(id, model, type);
    }

    public NumberTextField<N> setMinimum(N minimum) {
        this.minimum = minimum;
        return this;
    }

    public NumberTextField<N> setMaximum(N maximum) {
        this.maximum = maximum;
        return this;
    }

    @Override
    public void onConfigure() {
        super.onConfigure();
        if (this.validator != null) {
            this.remove(this.validator);
        }
        this.validator = new RangeValidator<Comparable>((Comparable)this.minimum, (Comparable)this.maximum);
        this.add(this.validator);
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        IValueMap attributes = tag.getAttributes();
        if (this.minimum != null) {
            attributes.put((Object)"min", this.minimum);
        } else {
            attributes.remove((Object)"min");
        }
        if (this.maximum != null) {
            attributes.put((Object)"max", this.maximum);
        } else {
            attributes.remove((Object)"max");
        }
    }

    @Override
    protected String getInputType() {
        return "number";
    }

    @Override
    public Locale getLocale() {
        return Locale.ENGLISH;
    }
}

