/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.repeater;

import java.util.Iterator;
import org.apache.wicket.markup.repeater.DefaultItemReuseStrategy;
import org.apache.wicket.markup.repeater.IItemFactory;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Generics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RefreshingView<T>
extends RepeatingView {
    private static final long serialVersionUID = 1L;
    private IItemReuseStrategy itemReuseStrategy;

    public RefreshingView(String id) {
        super(id);
    }

    public RefreshingView(String id, IModel<?> model) {
        super(id, model);
    }

    @Override
    protected final void onPopulate() {
        Iterator<IModel<T>> models = this.getItemModels();
        Iterator<Item<T>> items = this.getItemReuseStrategy().getItems(this.newItemFactory(), models, this.getItems());
        this.removeAll();
        this.addItems(items);
    }

    protected IItemFactory<T> newItemFactory() {
        return new IItemFactory<T>(){

            @Override
            public Item<T> newItem(int index, IModel<T> model) {
                String id = RefreshingView.this.newChildId();
                Item item = RefreshingView.this.newItem(id, index, model);
                RefreshingView.this.populateItem(item);
                return item;
            }
        };
    }

    protected abstract Iterator<IModel<T>> getItemModels();

    protected abstract void populateItem(Item<T> var1);

    protected Item<T> newItem(String id, int index, IModel<T> model) {
        return new Item<T>(id, index, model);
    }

    public Iterator<Item<T>> getItems() {
        return Generics.iterator(this.iterator());
    }

    protected void addItems(Iterator<Item<T>> items) {
        int index = 0;
        while (items.hasNext()) {
            Item<T> item = items.next();
            item.setIndex(index);
            this.add(item);
            ++index;
        }
    }

    public IItemReuseStrategy getItemReuseStrategy() {
        if (this.itemReuseStrategy == null) {
            return DefaultItemReuseStrategy.getInstance();
        }
        return this.itemReuseStrategy;
    }

    public RefreshingView<T> setItemReuseStrategy(IItemReuseStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException();
        }
        if (!strategy.equals(this.itemReuseStrategy)) {
            if (this.isVersioned()) {
                this.addStateChange();
            }
            this.itemReuseStrategy = strategy;
        }
        return this;
    }
}

