/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.page;

import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.page.IPageManager;
import org.apache.wicket.page.IPageManagerContext;
import org.apache.wicket.page.RequestAdapter;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPageManager
implements IPageManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractPageManager.class);
    private final IPageManagerContext context;

    public AbstractPageManager(IPageManagerContext context) {
        this.context = (IPageManagerContext)Args.notNull((Object)context, (String)"context");
    }

    protected abstract RequestAdapter newRequestAdapter(IPageManagerContext var1);

    public abstract boolean supportsVersioning();

    public abstract void sessionExpired(String var1);

    public IPageManagerContext getContext() {
        return this.context;
    }

    protected RequestAdapter getRequestAdapter() {
        RequestAdapter adapter = (RequestAdapter)this.getContext().getRequestData();
        if (adapter == null) {
            adapter = this.newRequestAdapter(this.getContext());
            this.getContext().setRequestData(adapter);
        }
        return adapter;
    }

    public void commitRequest() {
        this.getRequestAdapter().commitRequest();
    }

    public IManageablePage getPage(int id) {
        IManageablePage page = this.getRequestAdapter().getPage(id);
        if (page != null) {
            this.touchPage(page);
        }
        return page;
    }

    public void newSessionCreated() {
        this.getRequestAdapter().newSessionCreated();
    }

    public void touchPage(IManageablePage page) {
        if (!page.isPageStateless()) {
            this.getContext().bind();
        }
        this.getRequestAdapter().touch(page);
    }
}

